/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.FTPConnection;
import adams.flow.transformer.AbstractTransformer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;

public class FTPGet
extends AbstractTransformer {
    private static final long serialVersionUID = -5015637337437403790L;
    protected String m_RemoteDir;
    protected PlaceholderDirectory m_OutputDirectory;
    protected FTPConnection m_Connection;

    public String globalInfo() {
        return "Downloads a remote file and forwards the local file name.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"/pub");
        this.m_OptionManager.add("output-dir", "outputDirectory", (Object)new PlaceholderDirectory("."));
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"remoteDir", (Object)this.m_RemoteDir, (String)"download from ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputDirectory", (Object)this.m_OutputDirectory, (String)" to ");
        return result;
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The FTP directory to download the file from.";
    }

    public void setOutputDirectory(PlaceholderDirectory value) {
        this.m_OutputDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDirectory() {
        return this.m_OutputDirectory;
    }

    public String outputDirectoryTipText() {
        return "The directory to store the downloaded files in.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (FTPConnection)ActorUtils.findClosestType((AbstractActor)this, FTPConnection.class);
            if (this.m_Connection == null) {
                result = "No " + FTPConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        String file = (String)this.m_InputToken.getPayload();
        String remotefile = this.m_RemoteDir + "/" + file;
        String outFile = this.m_OutputDirectory.getAbsolutePath() + File.separator + file;
        FTPClient client = this.m_Connection.getFTPClient();
        FileOutputStream fos = null;
        BufferedOutputStream stream = null;
        try {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Downloading " + remotefile);
            }
            fos = new FileOutputStream(outFile);
            stream = new BufferedOutputStream(fos);
            client.retrieveFile(remotefile, (OutputStream)stream);
            stream.flush();
            stream.close();
            this.m_OutputToken = new Token((Object)outFile);
        }
        catch (Exception e) {
            try {
                result = this.handleException("Failed to download file '" + remotefile + "' to '" + outFile + "': ", e);
                this.m_OutputToken = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(stream);
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
            FileUtils.closeQuietly((OutputStream)stream);
            FileUtils.closeQuietly((OutputStream)fos);
        }
        FileUtils.closeQuietly((OutputStream)stream);
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }
}

