/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.sink.AbstractFileWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.net.URL;

public class DownloadFile
extends AbstractFileWriter {
    private static final long serialVersionUID = 8688918591152139449L;
    protected int m_BufferSize;

    public String globalInfo() {
        return "Downloads a file from a URL and saves it locally.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("buffer-size", "bufferSize", (Object)1024, (Number)1, null);
    }

    public String getQuickInfo() {
        String result = "Buffer: ";
        String variable = this.getOptionManager().getVariableForProperty("bufferSize");
        result = variable != null ? result + variable : result + this.m_BufferSize;
        return result;
    }

    public void setBufferSize(int value) {
        if (value > 0) {
            this.m_BufferSize = value;
            this.reset();
        } else {
            this.getSystemErr().println("Buffer must be >0, provided: " + value);
        }
    }

    public int getBufferSize() {
        return this.m_BufferSize;
    }

    public String bufferSizeTipText() {
        return "The size of byte-buffer used for reading/writing the content.";
    }

    public String outputFileTipText() {
        return "The file to save the downloaded content to.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, URL.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result;
        BufferedInputStream input = null;
        FilterOutputStream output = null;
        try {
            int len;
            URL url = this.m_InputToken.getPayload() instanceof String ? new URL((String)this.m_InputToken.getPayload()) : (URL)this.m_InputToken.getPayload();
            input = new BufferedInputStream(url.openStream());
            output = new BufferedOutputStream(new FileOutputStream(this.m_OutputFile.getAbsoluteFile()));
            byte[] buffer = new byte[this.m_BufferSize];
            int count = 0;
            while ((len = input.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, len);
                if (++count % 100 != 0) continue;
                ((BufferedOutputStream)output).flush();
            }
            ((BufferedOutputStream)output).flush();
            result = null;
        }
        catch (Exception e) {
            result = this.handleException("Problem downloading '" + this.m_InputToken.getPayload() + "': ", e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e) {}
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {}
        }
        return result;
    }
}

