/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.io.PlaceholderDirectory;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.SSHConnection;
import adams.flow.transformer.AbstractTransformer;
import com.jcraft.jsch.ChannelExec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class ScpFrom
extends AbstractTransformer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -5015637337437403790L;
    protected String m_RemoteDir;
    protected PlaceholderDirectory m_OutputDirectory;
    protected SSHConnection m_Connection;

    public String globalInfo() {
        return "Downloads a remote file and forwards the local file name using secure copy (SCP).\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.TITLE, "JSch - JSch is a pure Java implementation of SSH2.");
        result.setValue(TechnicalInformation.Field.HTTP, "http://www.jcraft.com/jsch/");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"/pub");
        this.m_OptionManager.add("output-dir", "outputDirectory", (Object)new PlaceholderDirectory("."));
    }

    public String getQuickInfo() {
        String result = "download from ";
        String variable = this.getOptionManager().getVariableForProperty("remoteDir");
        result = variable != null ? result + variable : result + this.m_RemoteDir;
        result = result + " to ";
        variable = this.getOptionManager().getVariableForProperty("outputDirectory");
        result = variable != null ? result + variable : result + this.m_OutputDirectory;
        return result;
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The remote directory to download the file from.";
    }

    public void setOutputDirectory(PlaceholderDirectory value) {
        this.m_OutputDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDirectory() {
        return this.m_OutputDirectory;
    }

    public String outputDirectoryTipText() {
        return "The directory to store the downloaded files in.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (SSHConnection)ActorUtils.findClosestType((AbstractActor)this, SSHConnection.class);
            if (this.m_Connection == null) {
                result = "No " + SSHConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        String file = (String)this.m_InputToken.getPayload();
        String remotefile = this.m_RemoteDir + "/" + file;
        String outFile = this.m_OutputDirectory.getAbsolutePath() + File.separator + file;
        ChannelExec channel = null;
        try {
            int c;
            channel = (ChannelExec)this.m_Connection.getSession().openChannel("exec");
            channel.setCommand("scp -f " + remotefile);
            if (this.isDebugOn()) {
                this.debug("Downloading " + remotefile);
            }
            InputStream in = channel.getInputStream();
            OutputStream out = channel.getOutputStream();
            byte[] buffer = new byte[1024];
            channel.connect();
            buffer[0] = 0;
            out.write(buffer, 0, 1);
            out.flush();
            while ((c = SSHConnection.checkAck(in)) == 67) {
                int foo;
                in.read(buffer, 0, 5);
                long filesize = 0L;
                while (in.read(buffer, 0, 1) >= 0 && buffer[0] != 32) {
                    filesize = filesize * 10L + (long)(buffer[0] - 48);
                }
                int i = 0;
                while (true) {
                    in.read(buffer, i, 1);
                    if (buffer[i] == 10) break;
                    ++i;
                }
                buffer[0] = 0;
                out.write(buffer, 0, 1);
                out.flush();
                FileOutputStream fos = new FileOutputStream(outFile);
                do {
                    foo = (long)buffer.length < filesize ? buffer.length : (int)filesize;
                    if ((foo = in.read(buffer, 0, foo)) < 0) break;
                    fos.write(buffer, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                fos = null;
                if (SSHConnection.checkAck(in) != 0) {
                    result = "Error occurred!";
                }
                buffer[0] = 0;
                out.write(buffer, 0, 1);
                out.flush();
            }
            if (result == null) {
                this.m_OutputToken = new Token((Object)outFile);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to download file '" + remotefile + "' to '" + outFile + "': ", e);
            this.m_OutputToken = null;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return result;
    }
}

