/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.net.Email;
import adams.core.option.OptionHandler;
import adams.data.io.output.MultiEmailWriter;
import adams.data.io.output.PropertiesEmailFileWriter;
import adams.flow.sink.AbstractFileWriter;
import java.util.Arrays;

public class EmailFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 393925191813730213L;
    protected adams.data.io.output.EmailFileWriter m_Writer;

    public String globalInfo() {
        return "Actor that writes Email objects to files.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", (Object)new PropertiesEmailFileWriter());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"writer", (Object)this.m_Writer);
    }

    protected PlaceholderFile getDefaultOutputFile() {
        return new PlaceholderFile("${TMP}/out.txt");
    }

    public String outputFileTipText() {
        return "The name of the output file.";
    }

    public void setWriter(adams.data.io.output.EmailFileWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public adams.data.io.output.EmailFileWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer for storing the spreadsheet.";
    }

    public Class[] accepts() {
        if (this.m_Writer instanceof MultiEmailWriter) {
            return new Class[]{Email[].class, Email.class};
        }
        return new Class[]{Email.class};
    }

    protected String doExecute() {
        String result = null;
        this.m_Writer.setOutput(this.m_OutputFile);
        if (this.m_InputToken.getPayload() instanceof Email) {
            Email sheet = (Email)((Object)this.m_InputToken.getPayload());
            String msg = this.m_Writer.write(sheet);
            if (msg != null) {
                result = "Problems writing email to '" + this.m_OutputFile + "': " + msg;
            }
        } else {
            Email[] sheets = (Email[])this.m_InputToken.getPayload();
            String msg = ((MultiEmailWriter)((Object)this.m_Writer)).write(Arrays.asList(sheets));
            if (msg != null) {
                result = "Problems writing emails to '" + this.m_OutputFile + "': " + msg;
            }
        }
        return result;
    }
}

