/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.ClassLister;
import adams.data.io.input.EmailFileReader;
import adams.data.io.input.PropertiesEmailFileReader;
import adams.data.io.output.EmailFileWriter;
import adams.data.io.output.PropertiesEmailFileWriter;
import adams.gui.chooser.AbstractExtensionFileFilterFileChooser;
import adams.gui.chooser.FileTypeDeterminingFileChooser;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.GenericObjectEditorDialog;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.utils.VFSUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyEditor;
import java.io.File;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EmailFileChooser
extends AbstractExtensionFileFilterFileChooser<EmailFileExtensionFilter>
implements FileTypeDeterminingFileChooser<EmailFileReader, EmailFileWriter> {
    private static final long serialVersionUID = -6341967475735162796L;
    protected static Vector<EmailFileExtensionFilter> m_ReaderFileFilters;
    protected static Vector<EmailFileExtensionFilter> m_WriterFileFilters;
    protected JButton m_ConfigureButton;
    protected JCheckBox m_CheckBoxOptions;
    protected JLabel m_LabelOptions;
    protected GenericObjectEditor m_Editor;

    public EmailFileChooser() {
    }

    public EmailFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public EmailFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    protected void initialize() {
        super.initialize();
        this.m_CheckBoxOptions = new JCheckBox("Invoke options dialog");
        this.m_CheckBoxOptions.setMnemonic('I');
        this.m_LabelOptions = new JLabel("<html><br>Note:<br><br>Some file formats offer additional<br>options which can be customized<br>when invoking the options dialog.</html>");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_CheckBoxOptions, "North");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.m_LabelOptions, "North");
        panel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)panel2, "Center");
        this.setAccessory(panel);
        this.m_Editor = new GenericObjectEditor(false);
        this.setAutoAppendExtension(true);
    }

    protected boolean getFiltersInitialized() {
        return m_ReaderFileFilters != null;
    }

    protected void doInitializeFilters() {
        EmailFileChooser.initFilters(true, ClassLister.getSingleton().getClassnames(EmailFileReader.class));
        EmailFileChooser.initFilters(false, ClassLister.getSingleton().getClassnames(EmailFileWriter.class));
    }

    protected static void initFilters(boolean reader, String[] classnames) {
        if (reader) {
            m_ReaderFileFilters = new Vector();
        } else {
            m_WriterFileFilters = new Vector();
        }
        for (int i = 0; i < classnames.length; ++i) {
            EmailFileExtensionFilter filter;
            String[] ext;
            String desc;
            Object converter;
            Class<?> cls;
            String classname = classnames[i];
            try {
                cls = Class.forName(classname);
                converter = cls.newInstance();
                if (reader) {
                    desc = ((EmailFileReader)converter).getFormatDescription();
                    ext = ((EmailFileReader)converter).getFormatExtensions();
                } else {
                    desc = ((EmailFileWriter)converter).getFormatDescription();
                    ext = ((EmailFileWriter)converter).getFormatExtensions();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to setup '" + classname + "':");
                e.printStackTrace();
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            if (reader) {
                filter = new EmailFileExtensionFilter(classname, desc, ext);
                m_ReaderFileFilters.add(filter);
                continue;
            }
            filter = new EmailFileExtensionFilter(classname, desc, ext);
            m_WriterFileFilters.add(filter);
        }
        if (reader) {
            Collections.sort(m_ReaderFileFilters);
        } else {
            Collections.sort(m_WriterFileFilters);
        }
    }

    protected Vector<EmailFileExtensionFilter> getOpenFileFilters() {
        return m_ReaderFileFilters;
    }

    protected Vector<EmailFileExtensionFilter> getSaveFileFilters() {
        return m_WriterFileFilters;
    }

    protected void initGUI(int dialogType) {
        super.initGUI(dialogType);
        if (dialogType == 1) {
            this.m_Editor.setClassType(EmailFileReader.class);
            this.m_Editor.setValue((Object)this.getDefaultReader());
        } else {
            this.m_Editor.setClassType(EmailFileWriter.class);
            this.m_Editor.setValue((Object)this.getDefaultWriter());
        }
        this.restoreLastFilter(dialogType);
    }

    protected EmailFileReader getDefaultReader() {
        return new PropertiesEmailFileReader();
    }

    protected EmailFileWriter getDefaultWriter() {
        return new PropertiesEmailFileWriter();
    }

    public VFSJFileChooser.RETURN_TYPE showOpenDialog(Component parent) {
        VFSJFileChooser.RETURN_TYPE result = super.showOpenDialog(parent);
        if (result == VFSJFileChooser.RETURN_TYPE.APPROVE && this.m_CheckBoxOptions.isSelected()) {
            this.m_Editor.setValue(this.m_CurrentHandler);
            GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog((Container)((Object)this), (PropertyEditor)this.m_Editor);
            dialog.setVisible(true);
            result = dialog.getResultType();
            if (result == VFSJFileChooser.RETURN_TYPE.APPROVE) {
                this.m_CurrentHandler = this.m_Editor.getValue();
            }
        }
        return result;
    }

    public VFSJFileChooser.RETURN_TYPE showSaveDialog(Component parent) {
        VFSJFileChooser.RETURN_TYPE result = super.showSaveDialog(parent);
        if (result == VFSJFileChooser.RETURN_TYPE.APPROVE && this.m_CheckBoxOptions.isSelected()) {
            this.m_Editor.setValue(this.m_CurrentHandler);
            GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog((Container)((Object)this), (PropertyEditor)this.m_Editor);
            dialog.setVisible(true);
            result = dialog.getResultType();
            if (result == VFSJFileChooser.RETURN_TYPE.APPROVE) {
                this.m_CurrentHandler = this.m_Editor.getValue();
            }
        }
        return result;
    }

    public EmailFileReader getReader() {
        this.configureCurrentHandlerHook(1);
        if (this.m_CurrentHandler instanceof EmailFileWriter) {
            return null;
        }
        return (EmailFileReader)this.m_CurrentHandler;
    }

    public EmailFileWriter getWriter() {
        this.configureCurrentHandlerHook(2);
        if (this.m_CurrentHandler instanceof EmailFileReader) {
            return null;
        }
        return (EmailFileWriter)this.m_CurrentHandler;
    }

    protected void updateCurrentHandlerHook() {
        try {
            String classname = ((EmailFileExtensionFilter)this.getFileFilter()).getClassname();
            Object newHandler = Class.forName(classname).newInstance();
            if (this.m_CurrentHandler == null) {
                this.m_CurrentHandler = newHandler;
            } else if (!this.m_CurrentHandler.getClass().equals(newHandler.getClass())) {
                this.m_CurrentHandler = newHandler;
            }
            this.setFileSelectionMode(VFSJFileChooser.SELECTION_MODE.FILES_ONLY);
        }
        catch (Exception e) {
            this.m_CurrentHandler = null;
            e.printStackTrace();
        }
    }

    protected void configureCurrentHandlerHook(int dialogType) {
        if (this.m_CurrentHandler == null) {
            String classname = ((EmailFileExtensionFilter)this.getFileFilter()).getClassname();
            try {
                this.m_CurrentHandler = Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_CurrentHandler = null;
            }
            if (this.m_CurrentHandler == null) {
                return;
            }
        }
    }

    public EmailFileReader getReaderForFile(File file) {
        EmailFileReader result = null;
        for (EmailFileExtensionFilter filter : m_ReaderFileFilters) {
            if (!filter.accept(VFSUtils.toFileObject((File)file))) continue;
            try {
                result = (EmailFileReader)Class.forName(filter.getClassname()).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate reader '" + filter.getClassname() + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    public EmailFileWriter getWriterForFile(File file) {
        EmailFileWriter result = null;
        for (EmailFileExtensionFilter filter : m_WriterFileFilters) {
            if (!filter.accept(VFSUtils.toFileObject((File)file))) continue;
            try {
                result = (EmailFileWriter)Class.forName(filter.getClassname()).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate writer '" + filter.getClassname() + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    public static class EmailFileExtensionFilter
    extends ExtensionFileFilter {
        private static final long serialVersionUID = -2968757331524482453L;
        protected String m_Classname;

        public EmailFileExtensionFilter(String classname) {
            this.m_Classname = classname;
        }

        public EmailFileExtensionFilter(String classname, String description, String extension) {
            super(description, extension);
            this.m_Classname = classname;
        }

        public EmailFileExtensionFilter(String classname, String description, String[] extensions) {
            super(description, extensions);
            this.m_Classname = classname;
        }

        public EmailFileExtensionFilter(String classname, String description, String extension, boolean caseSensitive) {
            super(description, extension, caseSensitive);
            this.m_Classname = classname;
        }

        public EmailFileExtensionFilter(String classname, String description, String[] extensions, boolean caseSensitive) {
            super(description, extensions, caseSensitive);
            this.m_Classname = classname;
        }

        public String getClassname() {
            return this.m_Classname;
        }

        public int compareTo(ExtensionFileFilter o) {
            int result = super.compareTo(o);
            if (o instanceof EmailFileExtensionFilter) {
                EmailFileExtensionFilter filter = (EmailFileExtensionFilter)o;
                if (result == 0) {
                    result = this.m_Classname.compareTo(filter.m_Classname);
                }
            }
            return result;
        }
    }
}

