/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.base.BasePassword;
import adams.core.net.AbstractSendEmail;
import adams.core.net.Email;
import adams.core.net.EmailAddress;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class JavaMailSendEmail
extends AbstractSendEmail {
    private static final long serialVersionUID = 4065886204614191616L;
    public static final String KEY_SMTPHOST = "mail.smtp.host";
    public static final String KEY_SMTPSHOST = "mail.smtps.host";
    public static final String KEY_SMTPPORT = "mail.smtp.port";
    public static final String KEY_SMTPSPORT = "mail.smtps.port";
    public static final String KEY_STARTTLS = "mail.smtp.starttls.enable";
    public static final String KEY_USESSL = "mail.smtp.ssl.enable";
    public static final String KEY_SMTPAUTH = "mail.smtp.auth";
    public static final String KEY_SMTPSAUTH = "mail.smtps.auth";
    public static final String KEY_SMTPTIMEOUT = "mail.smtp.timeout";
    public static final String KEY_SMTPSTIMEOUT = "mail.smtps.timeout";
    protected transient Session m_Session;

    public String globalInfo() {
        return "Uses JavaMail to send emails.";
    }

    @Override
    public boolean requiresSmtpSessionInitialization() {
        return this.m_Session == null;
    }

    @Override
    public void initializeSmtpSession(String server, int port, boolean useTLS, boolean useSSL, int timeout, boolean requiresAuth, final String user, final BasePassword pw) throws Exception {
        Properties props = (Properties)System.getProperties().clone();
        if (useSSL) {
            props.setProperty(KEY_USESSL, "" + useSSL);
            props.setProperty(KEY_STARTTLS, "" + useTLS);
            props.setProperty(KEY_SMTPSHOST, server);
            props.setProperty(KEY_SMTPSPORT, "" + port);
            props.setProperty(KEY_SMTPSAUTH, "" + requiresAuth);
            props.setProperty(KEY_SMTPSTIMEOUT, "" + timeout);
        } else {
            props.setProperty(KEY_STARTTLS, "" + useTLS);
            props.setProperty(KEY_SMTPHOST, server);
            props.setProperty(KEY_SMTPPORT, "" + port);
            props.setProperty(KEY_SMTPAUTH, "" + requiresAuth);
            props.setProperty(KEY_SMTPTIMEOUT, "" + timeout);
        }
        this.m_Session = requiresAuth ? Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, pw.getValue());
            }
        }) : Session.getInstance((Properties)props);
        this.m_Session.setDebug(this.isLoggingEnabled());
    }

    protected MimeMessage newMessage(EmailAddress fromAddress, EmailAddress[] toAddress, EmailAddress[] ccAddress, EmailAddress[] bccAddress, String subject) throws AddressException, MessagingException {
        int i;
        MimeMessage message = new MimeMessage(this.m_Session);
        message.setFrom((Address)new InternetAddress(fromAddress.getValue()));
        boolean noRecipient = true;
        if (toAddress != null) {
            noRecipient = noRecipient && toAddress.length == 0;
            for (i = 0; i < toAddress.length; ++i) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddress[i].getValue()));
            }
        }
        if (ccAddress != null) {
            noRecipient = noRecipient && ccAddress.length == 0;
            for (i = 0; i < ccAddress.length; ++i) {
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(ccAddress[i].getValue()));
            }
        }
        if (bccAddress != null) {
            noRecipient = noRecipient && bccAddress.length == 0;
            for (i = 0; i < bccAddress.length; ++i) {
                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bccAddress[i].getValue()));
            }
        }
        if (noRecipient) {
            throw new MessagingException("No recipients specified!");
        }
        message.setSubject(subject);
        return message;
    }

    @Override
    public boolean sendMail(Email email) throws Exception {
        if (this.m_Session == null) {
            throw new IllegalStateException("SMTP session not initialized!");
        }
        MimeMessage message = this.newMessage(email.getFrom(), email.getTo(), email.getCC(), email.getBCC(), email.getSubject());
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(email.getBody());
        multipart.addBodyPart((BodyPart)messageBodyPart);
        for (int i = 0; i < email.getAttachments().length; ++i) {
            messageBodyPart = new MimeBodyPart();
            messageBodyPart.setDataHandler(new DataHandler(email.getAttachments()[i].toURI().toURL()));
            messageBodyPart.setFileName(email.getAttachments()[i].getName());
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        message.setContent((Multipart)multipart);
        Transport.send((Message)message);
        return true;
    }
}

