/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseURL;
import adams.core.io.PlaceholderFile;
import adams.core.net.InetUtils;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractOnlineFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.URLSupplier;
import adams.flow.transformer.DownloadContent;
import junit.framework.Test;
import junit.framework.TestSuite;

public class DownloadContentTest
extends AbstractOnlineFlowTest {
    public DownloadContentTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("out.html");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("out.html");
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(DownloadContentTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        String host = "adams.cms.waikato.ac.nz";
        if (!InetUtils.hasConnection((String)host, (int)3000)) {
            System.err.println("No connection to host '" + host + "'? Trying anyway...");
        }
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] actors = new AbstractActor[3];
            URLSupplier url = new URLSupplier();
            argOption = (AbstractArgumentOption)url.getOptionManager().findByProperty("URLs");
            url.setURLs(new BaseURL[]{(BaseURL)argOption.valueOf("https://" + host + "/index.html")});
            actors[0] = url;
            DownloadContent download = new DownloadContent();
            actors[1] = download;
            DumpFile df = new DumpFile();
            df.setOutputFile(new PlaceholderFile("${TMP}/out.html"));
            actors[2] = df;
            flow.setActors(actors);
        }
        catch (Exception e) {
            DownloadContentTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        DownloadContentTest.runTest((Test)DownloadContentTest.suite());
    }
}

