/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseCharset;
import adams.core.base.BaseHostname;
import adams.core.io.EncodingSupporter;
import adams.core.option.OptionHandler;
import adams.data.statistics.StatUtils;
import adams.flow.sink.AbstractSink;

public class Socket
extends AbstractSink
implements EncodingSupporter,
ClassCrossReference {
    private static final long serialVersionUID = 6275418140787412381L;
    protected BaseHostname m_Address;
    protected BaseCharset m_Encoding;
    protected transient java.net.Socket m_Socket;

    public String globalInfo() {
        return "Just outputs the data to the specified socket.\nAny incoming data that isn't a byte array gets converted to a string and its bytes (using the specified encoding) are then transmitted.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("address", "address", (Object)new BaseHostname("127.0.0.1:8000"));
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
    }

    public void setAddress(BaseHostname value) {
        this.m_Address = value;
        this.reset();
    }

    public BaseHostname getAddress() {
        return this.m_Address;
    }

    public String addressTipText() {
        return "The address to connect to.";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding for sending the data.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"address", (Object)((Object)this.m_Address));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"encoding", (Object)this.m_Encoding, (String)", encoding: ");
        return result;
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{adams.flow.source.Socket.class};
    }

    public Class[] accepts() {
        return new Class[]{Object.class, byte[].class, Byte[].class};
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Socket == null) {
            try {
                this.m_Socket = new java.net.Socket(this.m_Address.hostnameValue(), this.m_Address.portValue());
            }
            catch (Exception e) {
                result = this.handleException("Failed to open socket to: " + (Object)((Object)this.m_Address), e);
                this.m_Socket = null;
            }
        }
        if (this.m_Socket != null) {
            try {
                byte[] bytes = this.m_InputToken.getPayload() instanceof byte[] ? (byte[])this.m_InputToken.getPayload() : (this.m_InputToken.getPayload() instanceof Byte[] ? StatUtils.toByteArray((Number[])((Byte[])this.m_InputToken.getPayload())) : ("" + this.m_InputToken.getPayload()).getBytes(this.m_Encoding.charsetValue()));
                this.m_Socket.getOutputStream().write(bytes);
                this.m_Socket.getOutputStream().flush();
            }
            catch (Exception e) {
                result = this.handleException("Failed to send data!", e);
            }
        }
        return result;
    }

    public void wrapUp() {
        if (this.m_Socket != null) {
            try {
                this.m_Socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_Socket = null;
        }
        super.wrapUp();
    }
}

