/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.License;
import adams.core.QuickInfoHelper;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingObject;
import adams.core.net.Scp;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.SSHConnection;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

@MixedCopyright(copyright="JCraft", license=License.BSD3, url="http://www.jcraft.com/jsch/")
public class ScpTo
extends AbstractTransformer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -5015637337437403790L;
    protected String m_RemoteDir;
    protected SSHConnection m_Connection;

    public String globalInfo() {
        return "Uploads a file to a remote directory using secure copy (SCP).\nThe file name of a successful upload gets forwarded.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.TITLE, "JSch - JSch is a pure Java implementation of SSH2.");
        result.setValue(TechnicalInformation.Field.HTTP, "http://www.jcraft.com/jsch/");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"/pub");
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"remoteDir", (Object)this.m_RemoteDir, (String)"upload to ");
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The remote directory to upload the file to.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (SSHConnection)ActorUtils.findClosestType((Actor)this, SSHConnection.class);
            if (this.m_Connection == null) {
                result = "No " + SSHConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String remoteFile;
        String filename = (String)this.m_InputToken.getPayload();
        PlaceholderFile localFile = new PlaceholderFile(filename);
        String result = Scp.copyTo((LoggingObject)this, this.m_Connection, (File)localFile, remoteFile = this.m_RemoteDir + "/" + localFile.getName());
        this.m_OutputToken = result == null ? new Token((Object)filename) : null;
        return result;
    }
}

