/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.fileoperations.FileOperations;
import adams.core.io.fileoperations.SmbFileOperations;
import adams.core.io.lister.DirectoryLister;
import adams.core.io.lister.SmbDirectoryLister;
import adams.core.net.SMBAuthenticationProvider;
import adams.core.option.OptionUtils;
import adams.gui.chooser.AbstractChooserPanelWithIOSupport;
import adams.gui.chooser.SmbRemoteDirectorySetup;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Component;
import java.awt.Dialog;

public class SmbDirectoryChooserPanel
extends AbstractChooserPanelWithIOSupport<SmbRemoteDirectorySetup> {
    private static final long serialVersionUID = 6235369491956122980L;
    protected SMBAuthenticationProvider m_Provider;

    public SmbDirectoryChooserPanel() {
        this.setCurrent(new SmbRemoteDirectorySetup());
    }

    protected void initialize() {
        super.initialize();
        this.reset();
    }

    protected void reset() {
        this.m_Provider = null;
    }

    public boolean setCurrent(SmbRemoteDirectorySetup value) {
        boolean result = super.setCurrent((Object)value);
        if (result) {
            this.reset();
        }
        return result;
    }

    protected SmbRemoteDirectorySetup doChoose() {
        SmbRemoteDirectorySetup currentSetup = (SmbRemoteDirectorySetup)this.getCurrent();
        GenericObjectEditorDialog dialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Remote directory");
        dialog.getGOEEditor().setClassType(SmbRemoteDirectorySetup.class);
        dialog.getGOEEditor().setCanChangeClassInDialog(false);
        dialog.setCurrent((Object)currentSetup);
        dialog.setLocationRelativeTo(GUIHelper.getParentComponent((Component)((Object)this)));
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return null;
        }
        SmbRemoteDirectorySetup newSetup = (SmbRemoteDirectorySetup)dialog.getCurrent();
        if (!newSetup.toCommandLine().equals(currentSetup.toCommandLine())) {
            this.reset();
        }
        return newSetup;
    }

    protected String toString(SmbRemoteDirectorySetup value) {
        return value.toCommandLine();
    }

    protected SmbRemoteDirectorySetup fromString(String value) {
        try {
            return (SmbRemoteDirectorySetup)OptionUtils.forAnyCommandLine(SmbRemoteDirectorySetup.class, (String)value);
        }
        catch (Exception e) {
            return new SmbRemoteDirectorySetup();
        }
    }

    public void setCurrentDirectory(String value) {
        SmbRemoteDirectorySetup current = (SmbRemoteDirectorySetup)this.getCurrent();
        current.setRemoteDir(value);
        this.setCurrent(current);
    }

    public String getCurrentDirectory() {
        return ((SmbRemoteDirectorySetup)this.getCurrent()).getRemoteDir();
    }

    public String getChooserType() {
        return "SMB";
    }

    protected synchronized SMBAuthenticationProvider getProvider() {
        if (this.m_Provider == null) {
            this.m_Provider = (SMBAuthenticationProvider)this.getCurrent();
        }
        return this.m_Provider;
    }

    public DirectoryLister getDirectoryLister() {
        SmbDirectoryLister result = new SmbDirectoryLister();
        result.setAuthenticationProvider(this.getProvider());
        result.setHost(((SmbRemoteDirectorySetup)this.getCurrent()).getHost());
        result.setWatchDir(this.getCurrentDirectory());
        return result;
    }

    public FileOperations getFileOperations() {
        SmbFileOperations result = new SmbFileOperations();
        result.setProvider(this.getProvider());
        return result;
    }
}

