/*
 * Decompiled with CFR 0.152.
 */
package adams.scripting.connection;

import adams.core.Utils;
import adams.core.base.BasePassword;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingSupporter;
import adams.core.net.JSchUtils;
import adams.core.net.SSHAuthenticationType;
import adams.core.net.SSHSessionProvider;
import adams.scripting.command.RemoteCommand;
import adams.scripting.connection.AbstractConnection;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import org.apache.commons.vfs2.provider.sftp.TrustEveryoneUserInfo;

public abstract class AbstractSSHConnection
extends AbstractConnection
implements SSHSessionProvider {
    private static final long serialVersionUID = 7719866884762680511L;
    protected String m_Host;
    protected int m_Port;
    protected SSHAuthenticationType m_AuthenticationType;
    protected String m_User;
    protected BasePassword m_Password;
    protected PlaceholderFile m_PrivateKeyFile;
    protected BasePassword m_PrivateKeyPassphrase;
    protected PlaceholderFile m_KnownHosts;
    protected boolean m_StrictHostKeyChecking;
    protected transient Session m_Session;
    protected int m_AssignedPort;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"127.0.0.1");
        this.m_OptionManager.add("port", "port", (Object)22, (Number)1, (Number)65535);
        this.m_OptionManager.add("authentication-type", "authenticationType", (Object)SSHAuthenticationType.CREDENTIALS);
        this.m_OptionManager.add("user", "user", (Object)System.getProperty("user.name"), false);
        this.m_OptionManager.add("password", "password", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("private-key-file", "privateKeyFile", (Object)new PlaceholderFile(System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "id_rsa"));
        this.m_OptionManager.add("private-key-passphrase", "privateKeyPassphrase", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("known-hosts", "knownHosts", (Object)new PlaceholderFile(System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "known_hosts"));
        this.m_OptionManager.add("strict-host-key-checking", "strictHostKeyChecking", (Object)true);
    }

    protected void reset() {
        super.reset();
        if (this.m_Session != null) {
            this.m_Session.disconnect();
            this.m_Session = null;
        }
    }

    public void setHost(String value) {
        this.m_Host = value;
        this.reset();
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The remote host (name/IP address) to connect to.";
    }

    public void setPort(int value) {
        if (this.getOptionManager().isValid("port", (Number)value)) {
            this.m_Port = value;
            this.reset();
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public String portTipText() {
        return "The remote SSH port to connect to.";
    }

    public void setAuthenticationType(SSHAuthenticationType value) {
        this.m_AuthenticationType = value;
        this.reset();
    }

    public SSHAuthenticationType getAuthenticationType() {
        return this.m_AuthenticationType;
    }

    public String authenticationTypeTipText() {
        return "The type of authentication to use.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The SSH user to use for connecting.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the SSH user to use for connecting.";
    }

    public void setPrivateKeyFile(PlaceholderFile value) {
        this.m_PrivateKeyFile = value;
        this.reset();
    }

    public PlaceholderFile getPrivateKeyFile() {
        return this.m_PrivateKeyFile;
    }

    public String privateKeyFileTipText() {
        return "The location of the private key.";
    }

    public void setPrivateKeyPassphrase(BasePassword value) {
        this.m_PrivateKeyPassphrase = value;
        this.reset();
    }

    public BasePassword getPrivateKeyPassphrase() {
        return this.m_PrivateKeyPassphrase;
    }

    public String privateKeyPassphraseTipText() {
        return "The passphrase for the private key file, ignored if empty.";
    }

    public void setKnownHosts(PlaceholderFile value) {
        this.m_KnownHosts = value;
        this.reset();
    }

    public PlaceholderFile getKnownHosts() {
        return this.m_KnownHosts;
    }

    public String knownHostsTipText() {
        return "The file storing the known hosts.";
    }

    public void setStrictHostKeyChecking(boolean value) {
        this.m_StrictHostKeyChecking = value;
        this.reset();
    }

    public boolean getStrictHostKeyChecking() {
        return this.m_StrictHostKeyChecking;
    }

    public String strictHostKeyCheckingTipText() {
        return "Enables/disables strict host key checking - strict checking is the recommended setting, as disabling it is very insecure!";
    }

    protected Session createSession(String host, int port) throws Exception {
        Session result;
        String password = this.m_Password.getValue();
        JSch jsch = JSchUtils.newJsch((File)this.m_KnownHosts);
        switch (this.m_AuthenticationType) {
            case CREDENTIALS: {
                result = JSchUtils.newSession(jsch, this.m_User, password, host, port);
                break;
            }
            case PUBLIC_KEY: {
                result = JSchUtils.newSession(jsch, this.m_User, (File)this.m_PrivateKeyFile, password, host, port);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled authentication type: " + (Object)((Object)this.m_AuthenticationType));
            }
        }
        JSchUtils.configureStrictHostKeyChecking(result, this.m_StrictHostKeyChecking);
        result.setUserInfo((UserInfo)new TrustEveryoneUserInfo());
        return result;
    }

    @Override
    public Session newSession() {
        return this.newSession(this.m_Host, this.m_Port);
    }

    @Override
    public Session newSession(String host, int port) {
        Session result;
        try {
            result = this.createSession(host, port);
            result.connect();
        }
        catch (Exception e) {
            Utils.handleException((LoggingSupporter)this, (String)("Failed to establish connection to '" + this.m_Host + "' (using " + (Object)((Object)this.m_AuthenticationType) + "): "), (Throwable)e);
            result = null;
        }
        return result;
    }

    @Override
    public Session getSession() {
        return this.m_Session;
    }

    protected abstract String doSend(RemoteCommand var1, boolean var2);

    protected synchronized String send(RemoteCommand cmd, boolean request) {
        String result = null;
        if (this.m_Session == null) {
            this.m_Session = this.newSession();
            if (this.m_Session == null) {
                result = "Failed to create new SSH session!";
            }
        }
        if (result == null) {
            result = this.doSend(cmd, request);
        }
        return result;
    }

    protected String doSendRequest(RemoteCommand cmd) {
        return this.send(cmd, true);
    }

    protected String doSendResponse(RemoteCommand cmd) {
        return this.send(cmd, false);
    }

    public void cleanUp() {
        if (this.m_Session != null) {
            if (this.m_Session.isConnected()) {
                this.m_Session.disconnect();
            }
            this.m_Session = null;
        }
        super.cleanUp();
    }
}

