/*
 * Decompiled with CFR 0.152.
 */
package adams.scripting.connection;

import adams.core.Utils;
import adams.core.logging.LoggingSupporter;
import adams.core.net.PortManager;
import adams.scripting.connection.AbstractSSHConnection;
import com.jcraft.jsch.Session;

public abstract class AbstractSSHConnectionWithPortForwarding
extends AbstractSSHConnection {
    private static final long serialVersionUID = 7719866884762680511L;
    protected int m_LocalPort;
    protected int m_ScriptingPort;
    protected int m_AssignedPort;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("local-port", "localPort", (Object)9000, (Number)-1, (Number)65535);
        this.m_OptionManager.add("scripting-port", "scriptingPort", (Object)12345, (Number)1, (Number)65535);
    }

    public void setLocalPort(int value) {
        if (this.getOptionManager().isValid("localPort", (Number)value)) {
            this.m_LocalPort = value;
            this.reset();
        }
    }

    public int getLocalPort() {
        return this.m_LocalPort;
    }

    public String localPortTipText() {
        return "The local port to connect to (SSH tunnel).";
    }

    public void setScriptingPort(int value) {
        if (this.getOptionManager().isValid("scriptingPort", (Number)value)) {
            this.m_ScriptingPort = value;
            this.reset();
        }
    }

    public int getScriptingPort() {
        return this.m_ScriptingPort;
    }

    public String scriptingPortTipText() {
        return "The port that the remote scripting engine is listening on.";
    }

    @Override
    public Session newSession(String host, int port) {
        Session result = super.newSession(host, port);
        if (result != null) {
            try {
                int localPort = this.m_LocalPort < 1 ? PortManager.getSingleton().next(this.getClass(), 9000) : this.m_LocalPort;
                this.m_AssignedPort = result.setPortForwardingL(localPort, host, this.m_ScriptingPort);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Assigned port: " + this.m_AssignedPort);
                }
            }
            catch (Exception e) {
                Utils.handleException((LoggingSupporter)this, (String)("Failed to establish connection to '" + this.m_Host + "' (using " + (Object)((Object)this.m_AuthenticationType) + "): "), (Throwable)e);
                result = null;
            }
        }
        return result;
    }

    @Override
    public void cleanUp() {
        if (this.m_Session != null && this.m_Session.isConnected()) {
            try {
                this.m_Session.delPortForwardingL(this.m_AssignedPort);
            }
            catch (Exception exception) {
                // empty catch block
            }
            PortManager.getSingleton().release(this.m_AssignedPort);
        }
        super.cleanUp();
    }
}

