/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.AbstractBaseObjectTestCase;
import adams.core.base.BaseHostname;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BaseHostnameTest
extends AbstractBaseObjectTestCase<BaseHostname> {
    public BaseHostnameTest(String name) {
        super(name);
    }

    protected BaseHostname getDefault() {
        return new BaseHostname();
    }

    protected BaseHostname getCustom(String s) {
        return new BaseHostname(s);
    }

    protected String getTypicalValue() {
        return Object.class.getName();
    }

    public void testInvalidHostname() {
        BaseHostname host = new BaseHostname();
        host.setValue("blah.bla&");
        BaseHostnameTest.assertNotSame((Object)"blah.blah", (Object)host.getValue());
    }

    public void testPort() {
        BaseHostname host = new BaseHostname();
        host.setValue("blah:22");
        BaseHostnameTest.assertEquals((int)22, (int)host.portValue());
        host = new BaseHostname();
        host.setValue("blah:220000");
        BaseHostnameTest.assertEquals((int)-1, (int)host.portValue());
        host = new BaseHostname();
        host.setValue("blah:-1");
        BaseHostnameTest.assertEquals((int)-1, (int)host.portValue());
        host = new BaseHostname();
        host.setValue("blah:65536");
        BaseHostnameTest.assertEquals((int)-1, (int)host.portValue());
        host = new BaseHostname();
        host.setValue("blah");
        BaseHostnameTest.assertEquals((int)-1, (int)host.portValue());
    }

    public void testHostname() {
        BaseHostname host = new BaseHostname();
        host.setValue("blah:22");
        BaseHostnameTest.assertEquals((String)"blah", (String)host.hostnameValue());
        host = new BaseHostname();
        host.setValue("adams.cms.waikato.ac.nz");
        BaseHostnameTest.assertEquals((String)"adams.cms.waikato.ac.nz", (String)host.hostnameValue());
        host = new BaseHostname();
        host.setValue("adams.cms.waikato.ac.nz:443");
        BaseHostnameTest.assertEquals((String)"adams.cms.waikato.ac.nz", (String)host.hostnameValue());
    }

    public static Test suite() {
        return new TestSuite(BaseHostnameTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BaseHostnameTest.runTest((Test)BaseHostnameTest.suite());
    }
}

