/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Properties;
import adams.core.io.PlaceholderFile;
import adams.core.net.Email;
import adams.core.net.EmailAddress;
import adams.core.option.OptionUtils;
import adams.data.io.input.AbstractEmailFileReader;
import java.io.File;
import java.util.logging.Level;

public class PropertiesEmailFileReader
extends AbstractEmailFileReader {
    private static final long serialVersionUID = -2721293194938632889L;
    public static final String KEY_FROM = "From";
    public static final String KEY_TO = "To";
    public static final String KEY_CC = "CC";
    public static final String KEY_BCC = "BCC";
    public static final String KEY_SUBJECT = "Subject";
    public static final String KEY_BODY = "Body";
    public static final String KEY_ATTACHMENTS = "Attachments";

    public String globalInfo() {
        return "Reads emails stored in properties files.";
    }

    @Override
    public String getFormatDescription() {
        return "Email properties files";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"props", "properties"};
    }

    protected EmailAddress[] getAddresses(Properties props, String key) throws Exception {
        String[] list = OptionUtils.splitOptions((String)props.getProperty(key, ""));
        EmailAddress[] result = new EmailAddress[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new EmailAddress(list[i]);
        }
        return result;
    }

    protected File[] getFiles(Properties props, String key) throws Exception {
        String[] list = OptionUtils.splitOptions((String)props.getProperty(key, ""));
        File[] result = new File[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new PlaceholderFile(list[i]).getAbsoluteFile();
        }
        return result;
    }

    @Override
    protected Email doRead() {
        Email result = null;
        Properties props = new Properties();
        if (!props.load(this.m_Input.getAbsolutePath())) {
            this.getLogger().severe("Failed to load email from " + this.m_Input);
            return result;
        }
        try {
            EmailAddress from = new EmailAddress(props.getProperty(KEY_FROM, ""));
            EmailAddress[] to = this.getAddresses(props, KEY_TO);
            EmailAddress[] cc = this.getAddresses(props, KEY_CC);
            EmailAddress[] bcc = this.getAddresses(props, KEY_BCC);
            String subject = props.getProperty(KEY_SUBJECT);
            String body = props.getProperty(KEY_BODY);
            File[] attachments = this.getFiles(props, KEY_ATTACHMENTS);
            result = new Email(from, to, cc, bcc, subject, body, attachments);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load email properties!", (Throwable)e);
            result = null;
        }
        return result;
    }
}

