/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseKeyValuePair;
import adams.core.base.BaseURL;
import adams.core.option.OptionHandler;
import adams.flow.container.HTMLRequestResult;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class HttpRequest
extends AbstractSimpleSource {
    private static final long serialVersionUID = 3114594997972970790L;
    protected BaseURL m_URL;
    protected Connection.Method m_Method;
    protected BaseKeyValuePair[] m_Headers;
    protected BaseKeyValuePair[] m_Parameters;
    protected StorageName m_Cookies;

    public String globalInfo() {
        return "Submits the (optional) form parameters to the specified URL and forwards the retrieved HTML as text.\nCookies can be retrieved and stored in internal storage, to be re-used with the next request.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)new BaseURL());
        this.m_OptionManager.add("method", "method", (Object)Connection.Method.POST);
        this.m_OptionManager.add("header", "headers", (Object)new BaseKeyValuePair[0]);
        this.m_OptionManager.add("parameter", "parameters", (Object)new BaseKeyValuePair[0]);
        this.m_OptionManager.add("cookies", "cookies", (Object)new StorageName());
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"URL", (Object)this.m_URL, (String)"URL: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"method", (Object)this.m_Method, (String)", method: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"cookies", (Object)this.m_Cookies, (String)", cookies: ");
        return result;
    }

    public void setURL(BaseURL value) {
        this.m_URL = value;
        this.reset();
    }

    public BaseURL getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The URL for the request.";
    }

    public void setMethod(Connection.Method value) {
        this.m_Method = value;
        this.reset();
    }

    public Connection.Method getMethod() {
        return this.m_Method;
    }

    public String methodTipText() {
        return "The method to use for the request.";
    }

    public void setHeaders(BaseKeyValuePair[] value) {
        this.m_Headers = value;
        this.reset();
    }

    public BaseKeyValuePair[] getHeaders() {
        return this.m_Headers;
    }

    public String headersTipText() {
        return "The (optional) request headers to send.";
    }

    public void setParameters(BaseKeyValuePair[] value) {
        this.m_Parameters = value;
        this.reset();
    }

    public BaseKeyValuePair[] getParameters() {
        return this.m_Parameters;
    }

    public String parametersTipText() {
        return "The form parameters to send with the request.";
    }

    public void setCookies(StorageName value) {
        this.m_Cookies = value;
        this.reset();
    }

    public StorageName getCookies() {
        return this.m_Cookies;
    }

    public String cookiesTipText() {
        return "The (optional) storage value with the cookies (map of strings).";
    }

    public Class[] generates() {
        return new Class[]{HTMLRequestResult.class};
    }

    protected String doExecute() {
        String result = null;
        Map cookies = null;
        if (this.getStorageHandler().getStorage().has(this.m_Cookies)) {
            cookies = (Map)this.getStorageHandler().getStorage().get(this.m_Cookies);
        }
        try {
            Connection conn = Jsoup.connect((String)this.m_URL.getValue());
            for (BaseKeyValuePair header : this.m_Headers) {
                conn.header(header.getPairKey(), header.getPairValue());
            }
            conn.data(BaseKeyValuePair.toMap((BaseKeyValuePair[])this.m_Parameters));
            conn.method(this.m_Method);
            if (cookies != null) {
                conn.cookies(cookies);
            }
            Connection.Response res = conn.execute();
            HTMLRequestResult cont = new HTMLRequestResult(res.statusCode(), res.statusMessage(), res.body(), res.cookies());
            this.m_OutputToken = new Token((Object)cont);
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute request: " + this.m_URL, e);
        }
        return result;
    }
}

