/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseKeyValuePair;
import adams.core.base.BaseURL;
import adams.core.option.OptionHandler;
import adams.flow.container.HTMLRequestResult;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import gnu.trove.list.array.TByteArrayList;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import org.jsoup.Connection;

public class HttpRequest
extends AbstractTransformer {
    private static final long serialVersionUID = 3114594997972970790L;
    protected BaseURL m_URL;
    protected Connection.Method m_Method;
    protected BaseKeyValuePair[] m_Headers;

    public String globalInfo() {
        return "Sends the incoming text payload to the specified URL (with optional HTTP headers) and forwards the retrieved HTML as text.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)new BaseURL());
        this.m_OptionManager.add("method", "method", (Object)Connection.Method.POST);
        this.m_OptionManager.add("header", "headers", (Object)new BaseKeyValuePair[0]);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"URL", (Object)this.m_URL, (String)"URL: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"method", (Object)this.m_Method, (String)", method: ");
        return result;
    }

    public void setURL(BaseURL value) {
        this.m_URL = value;
        this.reset();
    }

    public BaseURL getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The URL for the request.";
    }

    public void setMethod(Connection.Method value) {
        this.m_Method = value;
        this.reset();
    }

    public Connection.Method getMethod() {
        return this.m_Method;
    }

    public String methodTipText() {
        return "The method to use for the request.";
    }

    public void setHeaders(BaseKeyValuePair[] value) {
        this.m_Headers = value;
        this.reset();
    }

    public BaseKeyValuePair[] getHeaders() {
        return this.m_Headers;
    }

    public String headersTipText() {
        return "The (optional) request headers to send.";
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{HTMLRequestResult.class};
    }

    protected String doExecute() {
        String result = null;
        String payload = (String)this.m_InputToken.getPayload();
        try {
            int read;
            HttpURLConnection conn = (HttpURLConnection)this.m_URL.urlValue().openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod(this.m_Method.toString());
            for (BaseKeyValuePair header : this.m_Headers) {
                conn.setRequestProperty(header.getPairKey(), header.getPairValue());
            }
            OutputStream out = conn.getOutputStream();
            out.write(payload.getBytes());
            out.flush();
            out.close();
            TByteArrayList response = new TByteArrayList();
            InputStream in = conn.getInputStream();
            while ((read = in.read()) != -1) {
                response.add((byte)read);
            }
            HTMLRequestResult cont = new HTMLRequestResult(conn.getResponseCode(), conn.getResponseMessage(), new String(response.toArray()));
            this.m_OutputToken = new Token((Object)cont);
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute request: " + this.m_URL, e);
        }
        return result;
    }
}

