/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingObject;
import adams.core.net.Scp;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.SSHConnection;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class ScpFrom
extends AbstractTransformer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -5015637337437403790L;
    protected String m_RemoteDir;
    protected PlaceholderDirectory m_OutputDirectory;
    protected SSHConnection m_Connection;

    public String globalInfo() {
        return "Downloads a remote file and forwards the local file name using secure copy (SCP).\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.TITLE, "JSch - JSch is a pure Java implementation of SSH2.");
        result.setValue(TechnicalInformation.Field.HTTP, "http://www.jcraft.com/jsch/");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"");
        this.m_OptionManager.add("output-dir", "outputDirectory", (Object)new PlaceholderDirectory("."));
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"remoteDir", (Object)(this.m_RemoteDir.isEmpty() ? "<incoming>" : this.m_RemoteDir), (String)"download from ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputDirectory", (Object)this.m_OutputDirectory, (String)" to ");
        return result;
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The remote directory to download the file from.";
    }

    public void setOutputDirectory(PlaceholderDirectory value) {
        this.m_OutputDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDirectory() {
        return this.m_OutputDirectory;
    }

    public String outputDirectoryTipText() {
        return "The directory to store the downloaded files in.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (SSHConnection)ActorUtils.findClosestType((Actor)this, SSHConnection.class);
            if (this.m_Connection == null) {
                result = "No " + SSHConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String file = (String)this.m_InputToken.getPayload();
        String remoteFile = (this.m_RemoteDir.isEmpty() ? "" : this.m_RemoteDir + "/") + file;
        PlaceholderFile localFile = new PlaceholderFile(this.m_OutputDirectory.getAbsolutePath() + File.separator + file);
        String result = Scp.copyFrom((LoggingObject)this, this.m_Connection, remoteFile, (File)localFile);
        this.m_OutputToken = result == null ? new Token((Object)localFile) : null;
        return result;
    }
}

