/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.websocket.client;

import adams.core.logging.Logger;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.FlowContextHandler;
import adams.flow.core.QueueHelper;
import com.pusher.java_websocket.client.WebSocketClient;
import com.pusher.java_websocket.handshake.ServerHandshake;
import java.net.URI;
import java.util.logging.Level;

public class SimpleSendWithQueue
extends WebSocketClient
implements FlowContextHandler {
    protected Logger m_Logger;
    protected Actor m_FlowContext;
    protected StorageName m_Queue;

    public SimpleSendWithQueue(URI serverURI, Logger logger, StorageName queue) {
        super(serverURI);
        this.m_Logger = logger;
        this.m_Queue = queue;
    }

    public void setFlowContext(Actor value) {
        this.m_FlowContext = value;
    }

    public Actor getFlowContext() {
        return this.m_FlowContext;
    }

    protected synchronized Logger getLogger() {
        return this.m_Logger;
    }

    public void onOpen(ServerHandshake handshakedata) {
        this.getLogger().info("onOpen: " + handshakedata.getHttpStatus() + ": " + handshakedata.getHttpStatusMessage());
    }

    public void onMessage(String message) {
        this.getLogger().info("onMessage: " + message);
        if (this.m_FlowContext != null) {
            if (QueueHelper.hasQueue((Actor)this.getFlowContext(), (StorageName)this.m_Queue)) {
                QueueHelper.enqueue((Actor)this.getFlowContext(), (StorageName)this.m_Queue, (Object)message);
            } else {
                this.getLogger().severe("Queue not present: " + this.m_Queue);
            }
        } else {
            this.getLogger().severe("No flow context set!");
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        this.getLogger().info("onClose: code=" + code + ", reason=" + reason + ", remote=" + remote);
    }

    public void onError(Exception ex) {
        this.getLogger().log(Level.SEVERE, "Error occurred!", (Throwable)ex);
    }
}

