/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.websocket.server;

import adams.core.Utils;
import adams.core.logging.Logger;
import adams.flow.core.Actor;
import adams.flow.core.FlowContextHandler;
import com.pusher.java_websocket.WebSocket;
import com.pusher.java_websocket.handshake.ClientHandshake;
import com.pusher.java_websocket.server.WebSocketServer;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class EchoServer
extends WebSocketServer
implements FlowContextHandler {
    protected Logger m_Logger;
    protected Actor m_FlowContext;

    public EchoServer(InetSocketAddress address, Logger logger) {
        super(address);
        this.m_Logger = logger;
    }

    public void setFlowContext(Actor value) {
        this.m_FlowContext = value;
    }

    public Actor getFlowContext() {
        return this.m_FlowContext;
    }

    protected synchronized Logger getLogger() {
        return this.m_Logger;
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        this.getLogger().info("onOpen: " + conn.getRemoteSocketAddress());
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        this.getLogger().info("onClose: " + conn.getRemoteSocketAddress() + ", code=" + code + ", reason=" + reason + ", remote=" + remote);
    }

    public void onMessage(WebSocket conn, String message) {
        this.getLogger().info("onMessage: " + conn.getRemoteSocketAddress() + ", message=" + message);
        conn.send(message);
    }

    public void onMessage(WebSocket conn, ByteBuffer message) {
        this.getLogger().info("onMessage: " + conn.getRemoteSocketAddress() + ", message=" + Utils.toHexArray((byte[])message.array()));
        conn.send(message);
    }

    public void onError(WebSocket conn, Exception ex) {
        this.getLogger().log(Level.SEVERE, "Error occurred", (Throwable)ex);
    }
}

