/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.base.BasePassword;
import adams.core.net.SMBAuthenticationProvider;
import adams.core.option.AbstractOptionHandler;
import adams.gui.chooser.RemoteDirectorySetup;
import jcifs.smb.NtlmPasswordAuthentication;

public class SmbRemoteDirectorySetup
extends AbstractOptionHandler
implements SMBAuthenticationProvider,
RemoteDirectorySetup {
    private static final long serialVersionUID = -8429471751146663032L;
    protected String m_Domain;
    protected String m_User;
    protected BasePassword m_Password;
    protected String m_Host;
    protected String m_RemoteDir;
    protected transient NtlmPasswordAuthentication m_Session;

    public String globalInfo() {
        return "For configuring access to a remote directory via SFTP.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("domain", "domain", (Object)"");
        this.m_OptionManager.add("user", "user", (Object)System.getProperty("user.name"), false);
        this.m_OptionManager.add("password", "password", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("host", "host", (Object)"");
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"");
    }

    public void setHost(String value) {
        this.m_Host = value;
        this.reset();
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host (name/IP address) to connect to.";
    }

    public void setDomain(String value) {
        this.m_Domain = value;
        this.reset();
    }

    public String getDomain() {
        return this.m_Domain;
    }

    public String domainTipText() {
        return "The domain name to connect to.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The SMB user to use for connecting.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the SMB user to use for connecting.";
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The SFTP directory to download the file from.";
    }

    @Override
    public synchronized NtlmPasswordAuthentication getAuthentication() {
        if (this.m_Session == null) {
            this.m_Session = this.newAuthentication();
        }
        return this.m_Session;
    }

    @Override
    public NtlmPasswordAuthentication newAuthentication() {
        return new NtlmPasswordAuthentication(this.m_Domain, this.m_User, this.m_Password.getValue());
    }

    public void cleanUp() {
        this.m_Session = null;
    }

    public boolean requiresInitialization() {
        return true;
    }
}

