/*
 * Decompiled with CFR 0.152.
 */
package adams.scripting.connection;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.base.BasePassword;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.TempUtils;
import adams.core.logging.LoggingSupporter;
import adams.scripting.command.RemoteCommand;
import adams.scripting.connection.AbstractConnection;
import adams.scripting.processor.RemoteCommandProcessor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FTPConnection
extends AbstractConnection
implements ProtocolCommandListener {
    private static final long serialVersionUID = 7719866884762680511L;
    protected String m_Host;
    protected String m_User;
    protected BasePassword m_Password;
    protected boolean m_UsePassiveMode;
    protected boolean m_UseBinaryMode;
    protected String m_RemoteDir;
    protected FTPClient m_Client;

    public String globalInfo() {
        return "Uses an FTP to transfer commands.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"");
        this.m_OptionManager.add("user", "user", (Object)"anonymous", false);
        this.m_OptionManager.add("password", "password", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("passive", "usePassiveMode", (Object)false);
        this.m_OptionManager.add("binary", "useBinaryMode", (Object)false);
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"/pub");
    }

    public void setHost(String value) {
        this.m_Host = value;
        this.reset();
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host (name/IP address) to connect to.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The FTP user to use for connecting.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the FTP user to use for connecting.";
    }

    public void setUsePassiveMode(boolean value) {
        this.m_UsePassiveMode = value;
        this.reset();
    }

    public boolean getUsePassiveMode() {
        return this.m_UsePassiveMode;
    }

    public String usePassiveModeTipText() {
        return "If enabled, passive mode is used instead.";
    }

    public void setUseBinaryMode(boolean value) {
        this.m_UseBinaryMode = value;
        this.reset();
    }

    public boolean getUseBinaryMode() {
        return this.m_UseBinaryMode;
    }

    public String useBinaryModeTipText() {
        return "If enabled, binary mode is used instead of ASCII.";
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The FTP directory to upload the command to.";
    }

    protected String connect() {
        String result = null;
        try {
            this.m_Client = new FTPClient();
            this.m_Client.addProtocolCommandListener((ProtocolCommandListener)this);
            this.m_Client.connect(this.m_Host);
            int reply = this.m_Client.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                result = "FTP server refused connection: " + reply;
            } else if (!this.m_Client.login(this.m_User, this.m_Password.getValue())) {
                result = "Failed to connect to '" + this.m_Host + "' as user '" + this.m_User + "'";
            } else {
                if (this.m_UsePassiveMode) {
                    this.m_Client.enterLocalPassiveMode();
                }
                if (this.m_UseBinaryMode) {
                    this.m_Client.setFileType(2);
                }
            }
        }
        catch (Exception e) {
            result = Utils.handleException((LoggingSupporter)this, (String)("Failed to connect to '" + this.m_Host + "' as user '" + this.m_User + "': "), (Throwable)e);
            this.m_Client = null;
        }
        return result;
    }

    protected void disconnect() {
        if (this.m_Client != null && this.m_Client.isConnected()) {
            try {
                this.m_Client.disconnect();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to disconnect from '" + this.m_Host + "':", (Throwable)e);
            }
            this.m_Client.removeProtocolCommandListener((ProtocolCommandListener)this);
        }
        this.m_Client = null;
    }

    protected FTPClient getFTPClient() {
        if (this.m_Client == null) {
            this.connect();
        }
        return this.m_Client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doSend(RemoteCommand cmd, RemoteCommandProcessor processor) {
        MessageCollection errors;
        String result = null;
        File tmpfile = TempUtils.createTempFile((String)"remote", (String)".rc");
        if (!processor.write(cmd, tmpfile, errors = new MessageCollection())) {
            result = "Failed to write command to: " + tmpfile + "\n" + errors;
        }
        if (result == null) {
            FileInputStream fis;
            BufferedInputStream stream;
            block7: {
                String remotefile = TempUtils.createTempFile((PlaceholderDirectory)new PlaceholderDirectory(this.m_RemoteDir), (String)"remote", (String)".rc").getAbsolutePath();
                FTPClient client = this.getFTPClient();
                stream = null;
                fis = null;
                try {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Uploading " + tmpfile + " to " + remotefile);
                    }
                    if (client.storeFile(remotefile, (InputStream)(stream = new BufferedInputStream(fis = new FileInputStream(tmpfile.getAbsoluteFile()))))) break block7;
                    result = "Failed to upload file, check console for error message!";
                }
                catch (Exception e) {
                    try {
                        result = Utils.handleException((LoggingSupporter)this, (String)("Failed to upload file '" + tmpfile + "' to '" + remotefile + "': "), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeQuietly(stream);
                        FileUtils.closeQuietly(fis);
                        throw throwable;
                    }
                    FileUtils.closeQuietly((InputStream)stream);
                    FileUtils.closeQuietly((InputStream)fis);
                }
            }
            FileUtils.closeQuietly((InputStream)stream);
            FileUtils.closeQuietly((InputStream)fis);
        }
        return result;
    }

    protected String doSendRequest(RemoteCommand cmd, RemoteCommandProcessor processor) {
        return this.doSend(cmd, processor);
    }

    protected String doSendResponse(RemoteCommand cmd, RemoteCommandProcessor processor) {
        return this.doSend(cmd, processor);
    }

    public void protocolCommandSent(ProtocolCommandEvent event) {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("cmd sent: " + event.getCommand() + "/" + event.getReplyCode());
        } else if (event.getReplyCode() >= 400) {
            this.getLogger().severe("cmd sent: " + event.getCommand() + "/" + event.getReplyCode());
        }
    }

    public void protocolReplyReceived(ProtocolCommandEvent event) {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("reply received: " + event.getMessage() + "/" + event.getReplyCode());
        } else if (event.getReplyCode() >= 400) {
            this.getLogger().severe("reply received: " + event.getMessage() + "/" + event.getReplyCode());
        }
    }

    public void cleanUp() {
        this.disconnect();
        super.cleanUp();
    }
}

