/*
 * Decompiled with CFR 0.152.
 */
package adams.scripting.connection;

import adams.core.Utils;
import adams.core.logging.LoggingObject;
import adams.core.logging.LoggingSupporter;
import adams.core.net.JSchUtils;
import adams.scripting.command.RemoteCommand;
import adams.scripting.command.RemoteCommandWithResponse;
import adams.scripting.connection.AbstractSSHConnectionWithPortForwarding;
import adams.scripting.processor.RemoteCommandProcessor;
import com.jcraft.jsch.Session;
import java.net.Socket;

public class SSHConnection
extends AbstractSSHConnectionWithPortForwarding {
    private static final long serialVersionUID = 7719866884762680511L;
    protected boolean m_ForwardX;
    protected String m_XHost;
    protected int m_XPort;
    protected int m_Wait;

    public String globalInfo() {
        return "Uses an SSH tunnel to reach the remote scripting engine.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("forward-x", "forwardX", (Object)false);
        this.m_OptionManager.add("x-host", "XHost", (Object)"");
        this.m_OptionManager.add("x-port", "XPort", (Object)6000, (Number)1, (Number)65535);
        this.m_OptionManager.add("wait", "wait", (Object)2000, (Number)0, null);
    }

    public void setForwardX(boolean value) {
        this.m_ForwardX = value;
        this.reset();
    }

    public boolean getForwardX() {
        return this.m_ForwardX;
    }

    public String forwardXTipText() {
        return "If set to true, then X is forwarded.";
    }

    public void setXHost(String value) {
        this.m_XHost = value;
        this.reset();
    }

    public String getXHost() {
        return this.m_XHost;
    }

    public String XHostTipText() {
        return "The xhost (name/IP address) to connect to.";
    }

    public void setXPort(int value) {
        if (this.getOptionManager().isValid("XPort", (Number)value)) {
            this.m_XPort = value;
            this.reset();
        }
    }

    public int getXPort() {
        return this.m_XPort;
    }

    public String XPortTipText() {
        return "The xport to connect to.";
    }

    public void setWait(int value) {
        if (this.getOptionManager().isValid("wait", (Number)value)) {
            this.m_Wait = value;
            this.reset();
        }
    }

    public int getWait() {
        return this.m_Wait;
    }

    public String waitTipText() {
        return "The time in milli-second to wait before disconnecting the session.";
    }

    @Override
    protected Session createSession(String host, int port) throws Exception {
        Session result = super.createSession(host, port);
        if (this.m_ForwardX) {
            JSchUtils.configureX11(result, this.m_XHost, this.m_XPort);
        }
        return result;
    }

    @Override
    protected synchronized String doSend(RemoteCommand cmd, RemoteCommandProcessor processor, boolean request) {
        String result = null;
        String data = request ? cmd.assembleRequest(processor) : ((RemoteCommandWithResponse)cmd).assembleResponse(processor);
        try {
            Socket socket = new Socket("127.0.0.1", this.m_AssignedPort);
            socket.getOutputStream().write(data.getBytes());
            socket.getOutputStream().flush();
            socket.close();
        }
        catch (Exception e) {
            result = Utils.handleException((LoggingSupporter)cmd, (String)("Failed to send " + (request ? "request" : "response")), (Throwable)e);
        }
        if (this.m_Wait > 0) {
            Utils.wait((LoggingObject)this, (int)this.m_Wait, (int)100);
        }
        return result;
    }
}

