/*
 * Decompiled with CFR 0.152.
 */
package adams.scripting.connection;

import adams.core.MessageCollection;
import adams.core.io.FileUtils;
import adams.core.io.TempUtils;
import adams.core.logging.LoggingObject;
import adams.core.net.Scp;
import adams.scripting.command.RemoteCommand;
import adams.scripting.connection.AbstractSSHConnection;
import adams.scripting.processor.RemoteCommandProcessor;
import java.io.File;

public class ScpConnection
extends AbstractSSHConnection {
    private static final long serialVersionUID = 7165239073212488208L;
    protected String m_RemoteDir;

    public String globalInfo() {
        return "Copies the command as file to the remote host into the specified directory.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"/tmp");
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The remote directory to copy the command file to.";
    }

    @Override
    protected String doSend(RemoteCommand cmd, RemoteCommandProcessor processor, boolean request) {
        MessageCollection errors;
        String result = null;
        File tmpFile = TempUtils.createTempFile((String)"remote", (String)".rc");
        if (!processor.write(cmd, tmpFile, errors = new MessageCollection())) {
            result = "Failed to write command to: " + tmpFile + "\n" + errors;
        }
        if (result == null) {
            result = Scp.copyTo((LoggingObject)this, this, this.m_Host, this.m_Port, tmpFile, this.m_RemoteDir);
            if (!FileUtils.delete((File)tmpFile)) {
                this.getLogger().warning("Failed to delete tmp command file: " + tmpFile);
            }
        }
        return result;
    }
}

