/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.FileObject;
import java.io.File;
import java.util.Date;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class FtpFileObject
implements FileObject {
    private static final long serialVersionUID = -1391761454087211261L;
    protected FTPClient m_Client;
    protected String m_ParentDir;
    protected transient FTPFile m_File;

    public FtpFileObject(String parentDir, FTPFile file, FTPClient client) {
        this.m_ParentDir = parentDir;
        this.m_File = file;
        this.m_Client = client;
    }

    public FTPClient getClient() {
        return this.m_Client;
    }

    public String getParentDir() {
        return this.m_ParentDir;
    }

    public File getFile() {
        if (this.m_File != null) {
            return new File(this.m_ParentDir + "/" + this.m_File.getName());
        }
        return new File(this.m_ParentDir);
    }

    public File getActualFile() {
        return this.getFile();
    }

    public String getName() {
        if (this.m_File != null) {
            return this.m_File.getName();
        }
        return new File(this.m_ParentDir).getName();
    }

    public long getLength() {
        if (this.m_File != null) {
            return this.m_File.getSize();
        }
        return -1L;
    }

    public boolean isDirectory() {
        if (this.m_File != null) {
            return this.m_File.isDirectory();
        }
        return true;
    }

    public Date getLastModified() {
        if (this.m_File != null) {
            return new Date(this.m_File.getTimestamp().getTimeInMillis());
        }
        return new Date(0L);
    }

    public boolean isHidden() {
        if (this.m_File == null) {
            return false;
        }
        return this.getName().startsWith(".") && !this.isDirectory();
    }

    public boolean isLink() {
        if (this.m_File != null) {
            return this.m_File.isSymbolicLink();
        }
        return false;
    }

    public boolean isLocal() {
        return false;
    }

    public String toString() {
        return this.getFile().toString();
    }

    public int compareTo(FileObject o) {
        return this.getFile().compareTo(o.getFile());
    }

    public boolean equals(Object obj) {
        return obj instanceof FileObject && this.compareTo((FileObject)obj) == 0;
    }
}

