/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.fileoperations;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.fileoperations.AbstractRemoteFileOperations;
import adams.core.io.fileoperations.Operation;
import adams.core.logging.LoggingSupporter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;

public class FtpFileOperations
extends AbstractRemoteFileOperations {
    private static final long serialVersionUID = -4668267794023495691L;
    protected FTPClient m_Client;

    public void setClient(FTPClient value) {
        this.m_Client = value;
    }

    public FTPClient getClient() {
        return this.m_Client;
    }

    public boolean isSupported(Operation op) {
        switch (op) {
            case COPY: 
            case MOVE: 
            case RENAME: 
            case DELETE: 
            case MKDIR: {
                return true;
            }
        }
        throw new IllegalStateException("Unhandled operation: " + op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String copy(String source, String target) {
        String result = null;
        switch (this.m_Direction) {
            case LOCAL_TO_REMOTE: {
                String remoteFile = target;
                String inFile = source;
                BufferedInputStream istream = null;
                FileInputStream fis = null;
                try {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Uploading " + inFile + " to " + remoteFile);
                    }
                    fis = new FileInputStream(inFile);
                    istream = new BufferedInputStream(fis);
                    this.m_Client.storeFile(remoteFile, (InputStream)istream);
                }
                catch (Exception e) {
                    try {
                        result = Utils.handleException((LoggingSupporter)this, (String)("Failed to upload file '" + inFile + "' to '" + remoteFile + "': "), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeQuietly(istream);
                        FileUtils.closeQuietly(fis);
                        throw throwable;
                    }
                    FileUtils.closeQuietly((InputStream)istream);
                    FileUtils.closeQuietly((InputStream)fis);
                    break;
                }
                FileUtils.closeQuietly((InputStream)istream);
                FileUtils.closeQuietly((InputStream)fis);
                break;
            }
            case REMOTE_TO_LOCAL: {
                String remoteFile = source;
                String outFile = target;
                FileOutputStream fos = null;
                BufferedOutputStream ostream = null;
                try {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Downloading " + remoteFile);
                    }
                    fos = new FileOutputStream(outFile);
                    ostream = new BufferedOutputStream(fos);
                    this.m_Client.retrieveFile(remoteFile, (OutputStream)ostream);
                    ostream.flush();
                    ostream.close();
                }
                catch (Exception e) {
                    try {
                        result = Utils.handleException((LoggingSupporter)this, (String)("Failed to download file '" + remoteFile + "' to '" + outFile + "': "), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeQuietly(ostream);
                        FileUtils.closeQuietly(fos);
                        throw throwable;
                    }
                    FileUtils.closeQuietly((OutputStream)ostream);
                    FileUtils.closeQuietly((OutputStream)fos);
                    break;
                }
                FileUtils.closeQuietly((OutputStream)ostream);
                FileUtils.closeQuietly((OutputStream)fos);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled direction: " + this.m_Direction);
            }
        }
        return result;
    }

    public String move(String source, String target) {
        String result = this.copy(source, target);
        if (result == null) {
            switch (this.m_Direction) {
                case LOCAL_TO_REMOTE: {
                    if (FileUtils.delete((String)source)) break;
                    result = "Failed to delete: " + source;
                    break;
                }
                case REMOTE_TO_LOCAL: {
                    result = this.delete(source);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled direction: " + this.m_Direction);
                }
            }
        }
        return result;
    }

    protected String renameRemote(String source, String target) {
        try {
            this.m_Client.rename(source, target);
        }
        catch (Exception e) {
            return Utils.handleException((LoggingSupporter)this, (String)("Failed to rename file: " + source + " -> " + target), (Throwable)e);
        }
        return null;
    }

    protected String deleteRemote(String file) {
        try {
            this.m_Client.deleteFile(file);
        }
        catch (Exception e) {
            return Utils.handleException((LoggingSupporter)this, (String)("Failed to delete file: " + file), (Throwable)e);
        }
        return null;
    }

    protected String mkdirRemote(String dir) {
        try {
            this.m_Client.makeDirectory(dir);
        }
        catch (Exception e) {
            return Utils.handleException((LoggingSupporter)this, (String)("Failed to create diretory: " + dir), (Throwable)e);
        }
        return null;
    }
}

