/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.fileoperations;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.fileoperations.AbstractRemoteFileOperations;
import adams.core.io.fileoperations.Operation;
import adams.core.logging.LoggingSupporter;
import adams.core.net.SSHSessionProvider;
import com.jcraft.jsch.ChannelSftp;

public class SftpFileOperations
extends AbstractRemoteFileOperations {
    private static final long serialVersionUID = -4668267794023495691L;
    protected SSHSessionProvider m_Provider;

    public void setProvider(SSHSessionProvider value) {
        this.m_Provider = value;
    }

    public SSHSessionProvider getProvider() {
        return this.m_Provider;
    }

    public boolean isSupported(Operation op) {
        switch (op) {
            case COPY: 
            case MOVE: 
            case RENAME: 
            case DELETE: 
            case MKDIR: {
                return true;
            }
        }
        throw new IllegalStateException("Unhandled operation: " + op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String copy(String source, String target) {
        String result = null;
        ChannelSftp channel = null;
        switch (this.m_Direction) {
            case LOCAL_TO_REMOTE: {
                try {
                    channel = (ChannelSftp)this.m_Provider.getSession().openChannel("sftp");
                    channel.connect();
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Uploading " + source + " to " + target);
                    }
                    channel.put(new PlaceholderFile(source).getAbsolutePath(), target);
                    break;
                }
                catch (Exception e) {
                    result = Utils.handleException((LoggingSupporter)this, (String)("Failed to upload file '" + source + "' to '" + target + "': "), (Throwable)e);
                    break;
                }
                finally {
                    if (channel != null) {
                        channel.disconnect();
                    }
                }
            }
            case REMOTE_TO_LOCAL: {
                try {
                    channel = (ChannelSftp)this.m_Provider.getSession().openChannel("sftp");
                    channel.connect();
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Downloading " + source);
                    }
                    channel.get(source, new PlaceholderFile(target).getAbsolutePath());
                    channel.disconnect();
                    break;
                }
                catch (Exception e) {
                    result = Utils.handleException((LoggingSupporter)this, (String)("Failed to download file '" + source + "' to '" + target + "': "), (Throwable)e);
                    break;
                }
                finally {
                    if (channel != null) {
                        channel.disconnect();
                    }
                }
            }
            default: {
                throw new IllegalStateException("Unhandled direction: " + this.m_Direction);
            }
        }
        return result;
    }

    public String move(String source, String target) {
        String result = this.copy(source, target);
        if (result == null) {
            switch (this.m_Direction) {
                case LOCAL_TO_REMOTE: {
                    if (FileUtils.delete((String)source)) break;
                    result = "Failed to delete: " + source;
                    break;
                }
                case REMOTE_TO_LOCAL: {
                    result = this.delete(source);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled direction: " + this.m_Direction);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String renameRemote(String source, String target) {
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)this.m_Provider.getSession().openChannel("sftp");
            channel.connect();
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Renaming " + source + " to " + target);
            }
            channel.rename(source, target);
            channel.disconnect();
        }
        catch (Exception e) {
            String string = Utils.handleException((LoggingSupporter)this, (String)("Failed to rename file: " + source + " -> " + target), (Throwable)e);
            return string;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deleteRemote(String file) {
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)this.m_Provider.getSession().openChannel("sftp");
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Deleting " + file);
            }
            channel.rm(file);
            channel.disconnect();
        }
        catch (Exception e) {
            String string = Utils.handleException((LoggingSupporter)this, (String)("Failed to delete file: " + file), (Throwable)e);
            return string;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String mkdirRemote(String dir) {
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)this.m_Provider.getSession().openChannel("sftp");
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Creating directory " + dir);
            }
            channel.mkdir(dir);
            channel.disconnect();
        }
        catch (Exception e) {
            String string = Utils.handleException((LoggingSupporter)this, (String)("Failed to create directory: " + dir), (Throwable)e);
            return string;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return null;
    }
}

