/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.lister;

import adams.core.Utils;
import adams.core.base.BasePassword;
import adams.core.io.FileObject;
import adams.core.io.FtpFileObject;
import adams.core.io.lister.AbstractRecursiveDirectoryLister;
import adams.core.io.lister.SortContainer;
import adams.core.io.lister.Sorting;
import adams.core.logging.LoggingSupporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpDirectoryLister
extends AbstractRecursiveDirectoryLister
implements ProtocolCommandListener {
    private static final long serialVersionUID = 2687222234652386893L;
    protected String m_Host;
    protected String m_User;
    protected BasePassword m_Password;
    protected boolean m_UsePassiveMode;
    protected boolean m_UseBinaryMode;
    protected transient FTPClient m_Client;

    public void setHost(String value) {
        this.m_Host = value;
    }

    public String getHost() {
        return this.m_Host;
    }

    public void setUser(String value) {
        this.m_User = value;
    }

    public String getUser() {
        return this.m_User;
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public void setUsePassiveMode(boolean value) {
        this.m_UsePassiveMode = value;
    }

    public boolean getUsePassiveMode() {
        return this.m_UsePassiveMode;
    }

    public void setUseBinaryMode(boolean value) {
        this.m_UseBinaryMode = value;
    }

    public boolean getUseBinaryMode() {
        return this.m_UseBinaryMode;
    }

    public void setClient(FTPClient value) {
        this.m_Client = value;
    }

    public FTPClient getClient() {
        return this.m_Client;
    }

    protected FTPClient newClient() {
        FTPClient result;
        try {
            result = new FTPClient();
            result.addProtocolCommandListener((ProtocolCommandListener)this);
            result.connect(this.m_Host);
            int reply = result.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.getLogger().severe("FTP server refused connection: " + reply);
            } else if (!result.login(this.m_User, this.m_Password.getValue())) {
                this.getLogger().severe("Failed to connect to '" + this.m_Host + "' as user '" + this.m_User + "'");
            } else {
                if (this.m_UsePassiveMode) {
                    result.enterLocalPassiveMode();
                }
                if (this.m_UseBinaryMode) {
                    result.setFileType(2);
                }
            }
        }
        catch (Exception e) {
            Utils.handleException((LoggingSupporter)this, (String)("Failed to connect to '" + this.m_Host + "' as user '" + this.m_User + "': "), (Throwable)e);
            result = null;
        }
        return result;
    }

    protected void disconnect(FTPClient client) {
        if (client != null && client.isConnected()) {
            try {
                client.disconnect();
            }
            catch (Exception e) {
                Utils.handleException((LoggingSupporter)this, (String)"Failed to disconnect!", (Throwable)e);
            }
        }
    }

    public boolean isLocal() {
        return false;
    }

    public boolean hasParentDirectory() {
        return new File(this.m_WatchDir).getParentFile() != null;
    }

    public FtpFileObject newDirectory(String dir) {
        return this.newDirectory(this.m_WatchDir, dir);
    }

    public FtpFileObject newDirectory(String parent, String dir) {
        return new FtpFileObject(parent + "/" + dir, null, this.m_Client);
    }

    protected void search(FTPClient client, String current, List<SortContainer> files, int depth) throws Exception {
        if (depth == 0) {
            return;
        }
        if (this.getDebug()) {
            this.getLogger().info("search: current=" + current + ", depth=" + depth);
        }
        client.changeWorkingDirectory(current);
        ArrayList<FTPFile> currFiles = new ArrayList<FTPFile>();
        currFiles.addAll(Arrays.asList(client.listFiles()));
        if (currFiles.size() == 0) {
            if (this.getDebug()) {
                this.getLogger().info("No files listed!");
            }
            return;
        }
        for (int i = 0; i < currFiles.size() && !this.m_Stopped; ++i) {
            FTPFile entry = (FTPFile)currFiles.get(i);
            if (entry.isDirectory()) {
                if (entry.getName().equals(".") || entry.getName().equals("..")) continue;
                if (this.m_Recursive) {
                    this.search(client, current + "/" + entry.getName(), files, depth - 1);
                }
                if (!this.m_ListDirs || !this.m_RegExp.isEmpty() && !this.m_RegExp.isMatch(entry.getName())) continue;
                files.add(new SortContainer((FileObject)new FtpFileObject(current, entry, this.m_Client), this.m_Sorting));
                continue;
            }
            if (!this.m_ListFiles || !this.m_RegExp.isEmpty() && !this.m_RegExp.isMatch(entry.getName())) continue;
            files.add(new SortContainer((FileObject)new FtpFileObject(current, entry, this.m_Client), this.m_Sorting));
        }
    }

    public List<FtpFileObject> search(FTPClient client) throws Exception {
        ArrayList<FtpFileObject> result = new ArrayList<FtpFileObject>();
        this.m_Stopped = false;
        if (this.m_ListFiles || this.m_ListDirs) {
            int i;
            if (this.getDebug()) {
                this.getLogger().info("watching '" + this.m_WatchDir + "'");
            }
            if (this.getDebug()) {
                this.getLogger().info("before search(...)");
            }
            ArrayList<SortContainer> list = new ArrayList<SortContainer>();
            this.search(client, this.m_WatchDir, list, this.m_MaxDepth);
            if (this.getDebug()) {
                this.getLogger().info("before obtaining last modified timestamps");
            }
            if (!this.m_Stopped && this.m_Sorting != Sorting.NO_SORTING) {
                if (this.getDebug()) {
                    this.getLogger().info("before sorting");
                }
                Collections.sort(list);
                if (this.m_SortDescending) {
                    for (i = 0; i < list.size() / 2; ++i) {
                        SortContainer cont = (SortContainer)list.get(i);
                        list.set(i, (SortContainer)list.get(list.size() - 1 - i));
                        list.set(list.size() - 1 - i, cont);
                    }
                }
            }
            if (!this.m_Stopped) {
                if (this.getDebug()) {
                    this.getLogger().info("before matching");
                }
                for (i = 0; i < list.size(); ++i) {
                    result.add((FtpFileObject)((SortContainer)list.get(i)).getFile());
                    if (this.m_MaxItems > 0 && result.size() == this.m_MaxItems) {
                        if (!this.getDebug()) break;
                        this.getLogger().info("max size reached");
                        break;
                    }
                    if (this.m_Stopped) break;
                }
            }
        }
        if (this.m_Stopped) {
            result.clear();
        }
        return result;
    }

    public String[] list() {
        FtpFileObject[] wrappers = this.listObjects();
        String[] result = new String[wrappers.length];
        for (int i = 0; i < wrappers.length; ++i) {
            result[i] = wrappers[i].toString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FtpFileObject[] listObjects() {
        List<FtpFileObject> result;
        this.m_Stopped = false;
        FTPClient client = this.m_Client == null ? this.newClient() : this.m_Client;
        try {
            result = this.search(client);
        }
        catch (Exception e) {
            Utils.handleException((LoggingSupporter)this, (String)"Failed to list remote directory!", (Throwable)e);
            result = new ArrayList<FtpFileObject>();
        }
        finally {
            if (this.m_Client == null) {
                this.disconnect(client);
            }
        }
        return result.toArray(new FtpFileObject[result.size()]);
    }

    public void protocolCommandSent(ProtocolCommandEvent event) {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("cmd sent: " + event.getCommand() + "/" + event.getReplyCode());
        } else if (event.getReplyCode() >= 400) {
            this.getLogger().severe("cmd sent: " + event.getCommand() + "/" + event.getReplyCode());
        }
    }

    public void protocolReplyReceived(ProtocolCommandEvent event) {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("reply received: " + event.getMessage() + "/" + event.getReplyCode());
        } else if (event.getReplyCode() >= 400) {
            this.getLogger().severe("reply received: " + event.getMessage() + "/" + event.getReplyCode());
        }
    }
}

