/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.lister;

import adams.core.Utils;
import adams.core.base.BasePassword;
import adams.core.io.FileObject;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.SftpFileObject;
import adams.core.io.lister.AbstractRecursiveDirectoryLister;
import adams.core.io.lister.SortContainer;
import adams.core.io.lister.Sorting;
import adams.core.logging.LoggingSupporter;
import adams.core.net.JSchUtils;
import adams.core.net.SSHAuthenticationType;
import adams.core.net.SSHSessionProvider;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class SftpDirectoryLister
extends AbstractRecursiveDirectoryLister {
    private static final long serialVersionUID = 2687222234652386893L;
    protected String m_Host;
    protected int m_Port;
    protected SSHAuthenticationType m_AuthenticationType;
    protected String m_User;
    protected BasePassword m_Password;
    protected PlaceholderFile m_PrivateKeyFile;
    protected BasePassword m_PrivateKeyPassphrase;
    protected PlaceholderFile m_KnownHosts;
    protected boolean m_StrictHostKeyChecking;
    protected SSHSessionProvider m_SessionProvider;
    protected transient Session m_Session;

    public void setWatchDir(String value) {
        super.setWatchDir(FileUtils.useForwardSlashes((String)value));
    }

    public void setHost(String value) {
        this.m_Host = value;
    }

    public String getHost() {
        return this.m_Host;
    }

    public void setPort(int value) {
        if (value > 0 && value < 65535) {
            this.m_Port = value;
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setAuthenticationType(SSHAuthenticationType value) {
        this.m_AuthenticationType = value;
    }

    public SSHAuthenticationType getAuthenticationType() {
        return this.m_AuthenticationType;
    }

    public void setUser(String value) {
        this.m_User = value;
    }

    public String getUser() {
        return this.m_User;
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public void setPrivateKeyFile(PlaceholderFile value) {
        this.m_PrivateKeyFile = value;
    }

    public PlaceholderFile getPrivateKeyFile() {
        return this.m_PrivateKeyFile;
    }

    public void setPrivateKeyPassphrase(BasePassword value) {
        this.m_PrivateKeyPassphrase = value;
    }

    public BasePassword getPrivateKeyPassphrase() {
        return this.m_PrivateKeyPassphrase;
    }

    public void setKnownHosts(PlaceholderFile value) {
        this.m_KnownHosts = value;
    }

    public PlaceholderFile getKnownHosts() {
        return this.m_KnownHosts;
    }

    public void setStrictHostKeyChecking(boolean value) {
        this.m_StrictHostKeyChecking = value;
    }

    public boolean getStrictHostKeyChecking() {
        return this.m_StrictHostKeyChecking;
    }

    public void setSessionProvider(SSHSessionProvider value) {
        this.m_SessionProvider = value;
    }

    public SSHSessionProvider getSessionProvider() {
        return this.m_SessionProvider;
    }

    protected Session newSession() {
        return this.newSession(this.m_Host, this.m_Port);
    }

    protected Session newSession(String host, int port) {
        Session result;
        String password = this.m_Password.getValue();
        try {
            JSch jsch = JSchUtils.newJsch((File)this.m_KnownHosts);
            switch (this.m_AuthenticationType) {
                case CREDENTIALS: {
                    result = JSchUtils.newSession(jsch, this.m_User, password, host, port);
                    break;
                }
                case PUBLIC_KEY: {
                    result = JSchUtils.newSession(jsch, this.m_User, (File)this.m_PrivateKeyFile, password, host, port);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled authentication type: " + (Object)((Object)this.m_AuthenticationType));
                }
            }
            JSchUtils.configureStrictHostKeyChecking(result, this.m_StrictHostKeyChecking);
            result.connect();
        }
        catch (Exception e) {
            Utils.handleException((LoggingSupporter)this, (String)("Failed to establish connection to '" + host + "' (using " + (Object)((Object)this.m_AuthenticationType) + "): "), (Throwable)e);
            result = null;
        }
        return result;
    }

    protected void disconnect() {
        if (this.m_Session != null && this.m_Session.isConnected()) {
            try {
                this.m_Session.disconnect();
            }
            catch (Exception e) {
                Utils.handleException((LoggingSupporter)this, (String)("Failed to disconnect from '" + this.m_Host + "':"), (Throwable)e);
            }
        }
        this.m_Session = null;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean hasParentDirectory() {
        return new File(this.m_WatchDir).getParentFile() != null;
    }

    public SftpFileObject newDirectory(String dir) {
        return this.newDirectory(this.m_WatchDir, dir);
    }

    public SftpFileObject newDirectory(String parent, String dir) {
        return new SftpFileObject(new File(parent), dir, true, this.m_Session);
    }

    protected void search(ChannelSftp channel, String current, List<SortContainer> files, int depth) throws Exception {
        Vector currFiles;
        if (depth == 0) {
            return;
        }
        if (this.getDebug()) {
            this.getLogger().info("search: current=" + current + ", depth=" + depth);
        }
        if ((currFiles = channel.ls(current)) == null) {
            if (this.getDebug()) {
                this.getLogger().info("No files listed!");
            }
            return;
        }
        for (int i = 0; i < currFiles.size() && !this.m_Stopped; ++i) {
            if (!(currFiles.get(i) instanceof ChannelSftp.LsEntry)) continue;
            ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)currFiles.get(i);
            if (entry.getAttrs().isDir()) {
                if (entry.getFilename().equals(".") || entry.getFilename().equals("..")) continue;
                if (this.m_Recursive) {
                    this.search(channel, current + "/" + entry.getFilename(), files, depth - 1);
                }
                if (!this.m_ListDirs || !this.m_RegExp.isEmpty() && !this.m_RegExp.isMatch(entry.getFilename())) continue;
                files.add(new SortContainer((FileObject)new SftpFileObject(new File(current), entry, this.m_Session), this.m_Sorting));
                continue;
            }
            if (!this.m_ListFiles || !this.m_RegExp.isEmpty() && !this.m_RegExp.isMatch(entry.getFilename())) continue;
            files.add(new SortContainer((FileObject)new SftpFileObject(new File(current), entry, this.m_Session), this.m_Sorting));
        }
    }

    public List<SftpFileObject> search(ChannelSftp channel) throws Exception {
        ArrayList<SftpFileObject> result = new ArrayList<SftpFileObject>();
        this.m_Stopped = false;
        if (this.m_ListFiles || this.m_ListDirs) {
            int i;
            if (this.getDebug()) {
                this.getLogger().info("watching '" + this.m_WatchDir + "'");
            }
            if (this.getDebug()) {
                this.getLogger().info("before search(...)");
            }
            ArrayList<SortContainer> list = new ArrayList<SortContainer>();
            this.search(channel, this.m_WatchDir, list, this.m_MaxDepth);
            if (this.getDebug()) {
                this.getLogger().info("before obtaining last modified timestamps");
            }
            if (!this.m_Stopped && this.m_Sorting != Sorting.NO_SORTING) {
                if (this.getDebug()) {
                    this.getLogger().info("before sorting");
                }
                Collections.sort(list);
                if (this.m_SortDescending) {
                    for (i = 0; i < list.size() / 2; ++i) {
                        SortContainer cont = (SortContainer)list.get(i);
                        list.set(i, (SortContainer)list.get(list.size() - 1 - i));
                        list.set(list.size() - 1 - i, cont);
                    }
                }
            }
            if (!this.m_Stopped) {
                if (this.getDebug()) {
                    this.getLogger().info("before matching");
                }
                for (i = 0; i < list.size(); ++i) {
                    result.add((SftpFileObject)((SortContainer)list.get(i)).getFile());
                    if (this.m_MaxItems > 0 && result.size() == this.m_MaxItems) {
                        if (!this.getDebug()) break;
                        this.getLogger().info("max size reached");
                        break;
                    }
                    if (this.m_Stopped) break;
                }
            }
        }
        if (this.m_Stopped) {
            result.clear();
        }
        return result;
    }

    public String[] list() {
        SftpFileObject[] wrappers = this.listObjects();
        String[] result = new String[wrappers.length];
        for (int i = 0; i < wrappers.length; ++i) {
            result[i] = wrappers[i].toString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileObject[] listObjects() {
        List<Object> result = new ArrayList();
        this.m_Stopped = false;
        this.m_Session = this.m_SessionProvider != null ? this.m_SessionProvider.newSession() : this.newSession();
        ChannelSftp channel = null;
        if (this.m_Session != null) {
            try {
                channel = (ChannelSftp)this.m_Session.openChannel("sftp");
                channel.connect();
                result = this.search(channel);
            }
            catch (Exception e) {
                Utils.handleException((LoggingSupporter)this, (String)"Failed to list remote directory!", (Throwable)e);
                result = new ArrayList();
            }
            finally {
                if (channel != null) {
                    channel.disconnect();
                }
            }
        }
        this.disconnect();
        return result.toArray(new SftpFileObject[result.size()]);
    }
}

