/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.base.BaseKeyValuePair;
import adams.core.base.BaseURL;
import adams.flow.container.HTMLRequestResult;
import gnu.trove.list.array.TByteArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import org.jsoup.Connection;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;

public class HttpRequestHelper {
    public static HTMLRequestResult send(BaseURL url, Connection.Method method, BaseKeyValuePair[] headers, byte[] payload) throws Exception {
        HTMLRequestResult result;
        HttpURLConnection conn = (HttpURLConnection)url.urlValue().openConnection();
        conn.setDoOutput(payload != null);
        conn.setDoInput(true);
        conn.setRequestMethod(method.toString());
        if (headers != null) {
            for (BaseKeyValuePair header : headers) {
                conn.setRequestProperty(header.getPairKey(), header.getPairValue());
            }
        }
        if (payload != null) {
            OutputStream out = conn.getOutputStream();
            out.write(payload);
            out.flush();
            out.close();
        }
        try {
            int read;
            TByteArrayList response = new TByteArrayList();
            InputStream in = conn.getInputStream();
            while ((read = in.read()) != -1) {
                response.add((byte)read);
            }
            result = new HTMLRequestResult(conn.getResponseCode(), conn.getResponseMessage(), new String(response.toArray()));
        }
        catch (IOException e) {
            result = new HTMLRequestResult(conn.getResponseCode(), conn.getResponseMessage(), null);
        }
        return result;
    }

    public static HTMLRequestResult send(BaseURL url, Connection.Method method, BaseKeyValuePair[] headers, String payload, String encoding) throws Exception {
        HTMLRequestResult result;
        HttpURLConnection conn = (HttpURLConnection)url.urlValue().openConnection();
        conn.setDoOutput(payload != null);
        conn.setDoInput(true);
        conn.setRequestMethod(method.toString());
        if (headers != null) {
            for (BaseKeyValuePair header : headers) {
                conn.setRequestProperty(header.getPairKey(), header.getPairValue());
            }
        }
        if (payload != null) {
            OutputStream out = conn.getOutputStream();
            OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, "UTF-8");
            writer.write(payload);
            writer.flush();
            writer.close();
            out.flush();
            out.close();
        }
        try {
            int read;
            TByteArrayList response = new TByteArrayList();
            InputStream in = conn.getInputStream();
            while ((read = in.read()) != -1) {
                response.add((byte)read);
            }
            result = new HTMLRequestResult(conn.getResponseCode(), conn.getResponseMessage(), new String(response.toArray()));
        }
        catch (IOException e) {
            result = new HTMLRequestResult(conn.getResponseCode(), conn.getResponseMessage(), null);
        }
        return result;
    }

    public static HTMLRequestResult send(BaseURL url, Connection.Method method, BaseKeyValuePair[] headers, BaseKeyValuePair[] parameters, BaseKeyValuePair[] cookies) throws Exception {
        HTMLRequestResult result;
        Connection conn = Jsoup.connect((String)url.getValue());
        for (BaseKeyValuePair header : headers) {
            conn.header(header.getPairKey(), header.getPairValue());
        }
        conn.data(BaseKeyValuePair.toMap((BaseKeyValuePair[])parameters));
        conn.method(method);
        if (cookies != null) {
            conn.cookies(BaseKeyValuePair.toMap((BaseKeyValuePair[])cookies));
        }
        try {
            Connection.Response res = conn.execute();
            result = new HTMLRequestResult(res.statusCode(), res.statusMessage(), res.body(), res.cookies());
        }
        catch (HttpStatusException e) {
            result = new HTMLRequestResult(e.getStatusCode(), e.getMessage(), null);
        }
        return result;
    }
}

