/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.logging.LoggingObject;
import adams.core.logging.LoggingSupporter;
import adams.core.net.SMBAuthenticationProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;

public class SMB {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyTo(LoggingObject owner, SMBAuthenticationProvider provider, File localFile, String remoteFile) {
        String result = null;
        NtlmPasswordAuthentication auth = provider.getAuthentication();
        SmbFileOutputStream sos = null;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        byte[] buffer = new byte[8192];
        try {
            int read;
            sos = new SmbFileOutputStream(new SmbFile(remoteFile, auth));
            fis = new FileInputStream(localFile.getAbsolutePath());
            bis = new BufferedInputStream(fis);
            while ((read = bis.read(buffer)) != -1) {
                sos.write(buffer, 0, read);
            }
        }
        catch (Exception e) {
            try {
                result = Utils.handleException((LoggingSupporter)owner, (String)("Failed to upload file '" + localFile + "' to '" + remoteFile + "': "), (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(sos);
                FileUtils.closeQuietly(bis);
                FileUtils.closeQuietly(fis);
                throw throwable;
            }
            FileUtils.closeQuietly((OutputStream)sos);
            FileUtils.closeQuietly((InputStream)bis);
            FileUtils.closeQuietly((InputStream)fis);
        }
        FileUtils.closeQuietly((OutputStream)sos);
        FileUtils.closeQuietly((InputStream)bis);
        FileUtils.closeQuietly((InputStream)fis);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyFrom(LoggingObject owner, SMBAuthenticationProvider provider, String remoteFile, File localFile) {
        String result = null;
        NtlmPasswordAuthentication auth = provider.getAuthentication();
        SmbFileInputStream sis = null;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        byte[] buffer = new byte[8192];
        try {
            int read;
            sis = new SmbFileInputStream(new SmbFile(remoteFile, auth));
            fos = new FileOutputStream(localFile.getAbsolutePath());
            bos = new BufferedOutputStream(fos);
            while ((read = sis.read(buffer)) != -1) {
                bos.write(buffer, 0, read);
            }
        }
        catch (Exception e) {
            try {
                result = Utils.handleException((LoggingSupporter)owner, (String)("Failed to download file '" + remoteFile + "' to '" + localFile + "': "), (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(sis);
                FileUtils.closeQuietly(bos);
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)sis);
            FileUtils.closeQuietly((OutputStream)bos);
            FileUtils.closeQuietly((OutputStream)fos);
        }
        FileUtils.closeQuietly((InputStream)sis);
        FileUtils.closeQuietly((OutputStream)bos);
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }
}

