/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.Properties;
import adams.env.Environment;
import jcifs.Config;

public class SMBHelper {
    public static final String FILENAME = "SMB.props";
    public static final String WINS_HOST = "WinsHost";
    protected static Properties m_Properties;

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Environment.getInstance().read("smb");
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public static synchronized boolean writeProperties() {
        return SMBHelper.writeProperties(SMBHelper.getProperties());
    }

    public static synchronized boolean writeProperties(Properties props) {
        boolean result = Environment.getInstance().write("smb", props);
        m_Properties = null;
        return result;
    }

    public static String getWinsHost() {
        return SMBHelper.getProperties().getProperty(WINS_HOST, "192.168.1.220");
    }

    public static synchronized void initialize() {
        Config.setProperty((String)"jcifs.netbios.wins", (String)SMBHelper.getWinsHost());
    }
}

