/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.logging.LoggingObject;
import adams.core.logging.LoggingSupporter;
import adams.core.net.SSHSessionProvider;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Scp {
    public static String copyTo(LoggingObject owner, SSHSessionProvider provider, File localFile, String remoteFile) {
        return Scp.copyTo(owner, provider, null, -1, localFile, remoteFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyTo(LoggingObject owner, SSHSessionProvider provider, String host, int port, File localFile, String remoteFile) {
        String result = null;
        Session session = null;
        ChannelExec channel = null;
        boolean closeSession = host != null;
        try {
            int len;
            session = host == null ? provider.getSession() : provider.newSession(host, port);
            if (session == null) {
                String string = "Failed to initialize session (provider=" + provider + ", host=" + host + ", port=" + port + ")!";
                return string;
            }
            host = session.getHost();
            port = session.getPort();
            channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand("scp -p -t " + remoteFile);
            if (owner != null && owner.isLoggingEnabled()) {
                owner.getLogger().info("Uploading " + localFile + " to " + host + ":" + port + remoteFile);
            }
            InputStream in = channel.getInputStream();
            OutputStream out = channel.getOutputStream();
            channel.connect();
            if (Scp.checkAck(in) != 0) {
                String string = result = "Input stream check failed after opening channel!";
                return string;
            }
            long filesize = localFile.length();
            String command = "C0644 " + filesize + " " + localFile.getName() + "\n";
            out.write(command.getBytes());
            out.flush();
            if (Scp.checkAck(in) != 0) {
                result = "Sending of filename failed!";
            }
            FileInputStream fis = new FileInputStream(localFile.getAbsoluteFile());
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, len);
            }
            FileUtils.closeQuietly((InputStream)fis);
            fis = null;
            buffer[0] = 0;
            out.write(buffer, 0, 1);
            out.flush();
            if (Scp.checkAck(in) != 0) {
                result = "Left-over data in input stream!";
            }
            FileUtils.closeQuietly((OutputStream)out);
        }
        catch (Exception e) {
            result = Utils.handleException((LoggingSupporter)owner, (String)("Failed to upload file '" + localFile + "' to '" + host + ":" + port + remoteFile + "': "), (Throwable)e);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        if (closeSession && session != null && session.isConnected()) {
            try {
                session.disconnect();
            }
            catch (Exception e) {
                Utils.handleException((LoggingSupporter)owner, (String)("Failed to disconnect from '" + host + "':"), (Throwable)e);
            }
        }
        return result;
    }

    public static String copyFrom(LoggingObject owner, SSHSessionProvider provider, String remoteFile, File localFile) {
        return Scp.copyFrom(owner, provider, null, -1, remoteFile, localFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyFrom(LoggingObject owner, SSHSessionProvider provider, String host, int port, String remoteFile, File localFile) {
        String result = null;
        Session session = null;
        ChannelExec channel = null;
        FileOutputStream fos = null;
        boolean closeSession = host != null;
        try {
            int c;
            session = host == null ? provider.getSession() : provider.newSession(host, port);
            if (session == null) {
                String string = "Failed to initialize session (provider=" + provider + ", host=" + host + ", port=" + port + ")!";
                return string;
            }
            host = session.getHost();
            port = session.getPort();
            channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand("scp -f " + remoteFile);
            if (owner != null && owner.isLoggingEnabled()) {
                owner.getLogger().info("Downloading " + host + ":" + port + remoteFile);
            }
            InputStream in = channel.getInputStream();
            OutputStream out = channel.getOutputStream();
            byte[] buffer = new byte[1024];
            channel.connect();
            buffer[0] = 0;
            out.write(buffer, 0, 1);
            out.flush();
            while ((c = Scp.checkAck(in)) == 67) {
                int foo;
                in.read(buffer, 0, 5);
                long filesize = 0L;
                while (in.read(buffer, 0, 1) >= 0 && buffer[0] != 32) {
                    filesize = filesize * 10L + (long)(buffer[0] - 48);
                }
                int i = 0;
                while (true) {
                    in.read(buffer, i, 1);
                    if (buffer[i] == 10) break;
                    ++i;
                }
                buffer[0] = 0;
                out.write(buffer, 0, 1);
                out.flush();
                fos = new FileOutputStream(localFile.getAbsolutePath());
                do {
                    foo = (long)buffer.length < filesize ? buffer.length : (int)filesize;
                    if ((foo = in.read(buffer, 0, foo)) < 0) break;
                    fos.write(buffer, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                FileUtils.closeQuietly((OutputStream)fos);
                fos = null;
                if (Scp.checkAck(in) != 0) {
                    result = "Error occurred!";
                }
                buffer[0] = 0;
                out.write(buffer, 0, 1);
                out.flush();
            }
        }
        catch (Exception e) {
            result = Utils.handleException((LoggingSupporter)owner, (String)("Failed to download file '" + host + ":" + port + remoteFile + "' to '" + localFile + "': "), (Throwable)e);
        }
        finally {
            FileUtils.closeQuietly(fos);
            if (channel != null) {
                channel.disconnect();
            }
        }
        if (closeSession && session != null && session.isConnected()) {
            try {
                session.disconnect();
            }
            catch (Exception e) {
                Utils.handleException((LoggingSupporter)owner, (String)("Failed to disconnect from '" + host + "':"), (Throwable)e);
            }
        }
        return result;
    }

    public static int checkAck(InputStream in) throws IOException {
        int result = in.read();
        if (result == 0) {
            return result;
        }
        if (result == -1) {
            return result;
        }
        if (result == 1 || result == 2) {
            int c;
            StringBuilder output = new StringBuilder();
            do {
                c = in.read();
                output.append((char)c);
            } while (c != 10);
            if (result == 1) {
                System.out.print(output.toString());
            }
            if (result == 2) {
                System.out.print(output.toString());
            }
        }
        return result;
    }
}

