/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.filesystemsearch;

import adams.core.io.lister.FtpDirectoryLister;
import adams.core.logging.LoggingLevel;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.source.filesystemsearch.AbstractFileSystemSearchlet;
import adams.flow.standalone.FTPConnection;
import adams.flow.standalone.SSHConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractFtpDirectoryListerBasedSearchlet
extends AbstractFileSystemSearchlet {
    private static final long serialVersionUID = -240436041323613527L;
    protected FtpDirectoryLister m_Lister;

    protected void initialize() {
        super.initialize();
        this.m_Lister = new FtpDirectoryLister();
    }

    public synchronized void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Lister.setLoggingLevel(value);
    }

    protected void check() throws Exception {
        super.check();
        if (this.m_FlowContext == null) {
            throw new IllegalStateException("No flow context provided, cannot obtain " + SSHConnection.class.getName() + "!");
        }
        FTPConnection conn = (FTPConnection)ActorUtils.findClosestType((Actor)this.m_FlowContext, FTPConnection.class);
        if (conn == null) {
            throw new IllegalStateException("No " + FTPConnection.class.getName() + " actor found!");
        }
        this.m_Lister.setClient(conn.getFTPClient());
    }

    protected List<String> doSearch() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(this.m_Lister.list()));
        return result;
    }

    public void stopExecution() {
        this.m_Stopped = true;
        this.m_Lister.stopExecution();
    }
}

