/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.filesystemsearch;

import adams.core.DefaultCompare;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.flow.source.filesystemsearch.AbstractSmbDirectoryListerBasedSearchlet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SmbDirectorySearchWithComparator
extends AbstractSmbDirectoryListerBasedSearchlet {
    private static final long serialVersionUID = 3229293554987103145L;
    protected Comparator m_Comparator;
    protected boolean m_Descending;

    public String globalInfo() {
        return "Searches only for directories, but uses the comparator for sorting the directories (SMB, Windows shares).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("directory", "directory", (Object)"");
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(""));
        this.m_OptionManager.add("max-items", "maxItems", (Object)-1);
        this.m_OptionManager.add("comparator", "comparator", (Object)new DefaultCompare());
        this.m_OptionManager.add("descending", "sortDescending", (Object)false);
        this.m_OptionManager.add("recursive", "recursive", (Object)false);
        this.m_OptionManager.add("max-depth", "maxDepth", (Object)-1);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Lister.setListDirs(true);
        this.m_Lister.setListFiles(false);
    }

    public void setDirectory(String value) {
        this.m_Lister.setWatchDir(value);
    }

    public String getDirectory() {
        return this.m_Lister.getWatchDir();
    }

    public String directoryTipText() {
        return "The directory to search for directories.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_Lister.setRegExp(value);
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_Lister.getRegExp();
    }

    public String regExpTipText() {
        return "The regular expression that the dirs must match (empty string matches all).";
    }

    public void setMaxItems(int value) {
        this.m_Lister.setMaxItems(value);
        this.reset();
    }

    public int getMaxItems() {
        return this.m_Lister.getMaxItems();
    }

    public String maxItemsTipText() {
        return "The maximum number of dirs to return (<= 0 is unlimited).";
    }

    public void setComparator(Comparator value) {
        this.m_Comparator = value;
        this.reset();
    }

    public Comparator getComparator() {
        return this.m_Comparator;
    }

    public String comparatorTipText() {
        return "The comparator to use; must implement " + Comparator.class.getName() + " and " + Serializable.class.getName();
    }

    public void setSortDescending(boolean value) {
        this.m_Descending = value;
        this.reset();
    }

    public boolean getSortDescending() {
        return this.m_Descending;
    }

    public String sortDescendingTipText() {
        return "If set to true, the directories are sorted in descending manner.";
    }

    public void setRecursive(boolean value) {
        this.m_Lister.setRecursive(value);
        this.reset();
    }

    public boolean getRecursive() {
        return this.m_Lister.getRecursive();
    }

    public String recursiveTipText() {
        return "Whether to search recursively or not.";
    }

    public void setMaxDepth(int value) {
        this.m_Lister.setMaxDepth(value);
        this.reset();
    }

    public int getMaxDepth() {
        return this.m_Lister.getMaxDepth();
    }

    public String maxDepthTipText() {
        return "The maximum depth to search in recursive mode (1 = only search directory, -1 = infinite).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"directory", (Object)this.getDirectory());
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"comparator", (Object)this.getComparator(), (String)", comparator: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"sortDescending", (boolean)this.getSortDescending(), (String)"descending"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"recursive", (boolean)this.getRecursive(), (String)"recursive"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"maxItems", (Object)(this.getMaxItems() > 0 ? Integer.valueOf(this.getMaxItems()) : null), (String)"max="));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    @Override
    protected List<String> doSearch() throws Exception {
        List<String> result = super.doSearch();
        Collections.sort(result, this.m_Comparator);
        if (this.m_Descending) {
            Collections.reverse(result);
        }
        return result;
    }
}

