/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.base.BasePassword;
import adams.core.io.ConsoleHelper;
import adams.core.net.AbstractSendEmail;
import adams.core.net.EmailHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.OptionalPasswordPrompt;
import adams.flow.core.StopHelper;
import adams.flow.core.StopMode;
import adams.flow.standalone.AbstractStandalone;
import adams.gui.dialog.PasswordDialog;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;

public class SMTPConnection
extends AbstractStandalone
implements OptionalPasswordPrompt {
    private static final long serialVersionUID = 9145039564243937635L;
    protected String m_Server;
    protected int m_Port;
    protected boolean m_UseTLS;
    protected boolean m_UseSSL;
    protected int m_Timeout;
    protected boolean m_RequiresAuthentication;
    protected String m_User;
    protected BasePassword m_Password;
    protected BasePassword m_ActualPassword;
    protected boolean m_PromptForPassword;
    protected boolean m_StopFlowIfCanceled;
    protected String m_CustomStopMessage;
    protected StopMode m_StopMode;

    public String globalInfo() {
        return "SMTP server setup for overriding default parameters.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("server", "server", (Object)EmailHelper.getSmtpServer());
        this.m_OptionManager.add("port", "port", (Object)EmailHelper.getSmtpPort(), (Number)1, (Number)65536);
        this.m_OptionManager.add("use-tls", "useTLS", (Object)EmailHelper.getSmtpStartTLS());
        this.m_OptionManager.add("use-ssl", "useSSL", (Object)EmailHelper.getSmtpUseSSL());
        this.m_OptionManager.add("timeout", "timeout", (Object)EmailHelper.getSmtpTimeout(), (Number)0, null);
        this.m_OptionManager.add("requires-auth", "requiresAuthentication", (Object)EmailHelper.getSmtpRequiresAuthentication());
        this.m_OptionManager.add("user", "user", (Object)EmailHelper.getSmtpUser(), false);
        this.m_OptionManager.add("password", "password", (Object)EmailHelper.getSmtpPassword(), false);
        this.m_OptionManager.add("prompt-for-password", "promptForPassword", (Object)false);
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", (Object)false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", (Object)"");
        this.m_OptionManager.add("stop-mode", "stopMode", (Object)StopMode.GLOBAL);
    }

    public String getQuickInfo() {
        String result = "";
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"requiresAuthentication") || this.m_RequiresAuthentication) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"user", (Object)this.m_User);
            String value = QuickInfoHelper.toString((OptionHandler)this, (String)"password", (Object)this.m_Password.getValue().replaceAll(".", "*"));
            if (value != null) {
                result = result + ":" + value;
            }
            result = result + "@";
        }
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"server", (Object)this.m_Server);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"port", (Object)this.m_Port, (String)":");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"useTLS", (boolean)this.m_UseTLS, (String)"TLS"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"useSSL", (boolean)this.m_UseSSL, (String)"SSL"));
        if ((QuickInfoHelper.hasVariable((OptionHandler)this, (String)"requiresAuthentication") || this.m_RequiresAuthentication) && (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"promptForPassword") || this.m_PromptForPassword)) {
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"promptForPassword", (boolean)this.m_PromptForPassword, (String)"prompt for password"));
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"stopFlowIfCanceled", (boolean)this.m_StopFlowIfCanceled, (String)"stop flow"));
        }
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setServer(String value) {
        this.m_Server = value;
        this.reset();
    }

    public String getServer() {
        return this.m_Server;
    }

    public String serverTipText() {
        return "The SMTP server (name/IP address) to use.";
    }

    public void setPort(int value) {
        if (value >= 1 && value <= 65536) {
            this.m_Port = value;
            this.reset();
        } else {
            this.getLogger().severe("Port has to satisfy 1<=x<=65536, provided: " + value);
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public String portTipText() {
        return "The SMTP port to use.";
    }

    public void setUseTLS(boolean value) {
        this.m_UseTLS = value;
        this.reset();
    }

    public boolean getUseTLS() {
        return this.m_UseTLS;
    }

    public String useTLSTipText() {
        return "If enabled, TLS (transport layer security) is used.";
    }

    public void setUseSSL(boolean value) {
        this.m_UseSSL = value;
        this.reset();
    }

    public boolean getUseSSL() {
        return this.m_UseSSL;
    }

    public String useSSLTipText() {
        return "If enabled, SSL (secure sockets layer) is used for connecting.";
    }

    public void setTimeout(int value) {
        if (value >= 0) {
            this.m_Timeout = value;
            this.reset();
        } else {
            this.getLogger().severe("Timeout has to be >= 0, provided: " + value);
        }
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public String timeoutTipText() {
        return "The timeout in msecs.";
    }

    public void setRequiresAuthentication(boolean value) {
        this.m_RequiresAuthentication = value;
        this.reset();
    }

    public boolean getRequiresAuthentication() {
        return this.m_RequiresAuthentication;
    }

    public String requiresAuthenticationTipText() {
        return "Enable this if SMTP server requires authentication using user/pw.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The SMTP user to use.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the SMTP user.";
    }

    public void setPromptForPassword(boolean value) {
        this.m_PromptForPassword = value;
        this.reset();
    }

    public boolean getPromptForPassword() {
        return this.m_PromptForPassword;
    }

    public String promptForPasswordTipText() {
        return "If enabled and authentication is required, the user gets prompted for enter a password if none has been provided in the setup.";
    }

    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    public void setStopMode(StopMode value) {
        this.m_StopMode = value;
        this.reset();
    }

    public StopMode getStopMode() {
        return this.m_StopMode;
    }

    public String stopModeTipText() {
        return "The stop mode to use.";
    }

    public boolean doInteract() {
        boolean result;
        PasswordDialog dlg = new PasswordDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL);
        dlg.setLocationRelativeTo(this.getParentComponent());
        ((Flow)this.getRoot()).registerWindow((Window)dlg, dlg.getTitle());
        dlg.setVisible(true);
        ((Flow)this.getRoot()).deregisterWindow((Window)dlg);
        boolean bl = result = dlg.getOption() == 0;
        if (result) {
            this.m_ActualPassword = dlg.getPassword();
        }
        return result;
    }

    public boolean supportsHeadlessInteraction() {
        return true;
    }

    public boolean doInteractHeadless() {
        boolean result = false;
        BasePassword password = ConsoleHelper.enterPassword((String)("Please enter password (" + this.getName() + "):"));
        if (password != null) {
            result = true;
            this.m_ActualPassword = password;
        }
        return result;
    }

    public void initializeSmtpSession(AbstractSendEmail sendEmail) throws Exception {
        sendEmail.initializeSmtpSession(this.m_Server, this.m_Port, this.m_UseTLS, this.m_UseSSL, this.m_Timeout, this.m_RequiresAuthentication, this.m_User, this.m_ActualPassword);
    }

    protected String doExecute() {
        String result = null;
        this.m_ActualPassword = this.m_Password;
        if (this.m_RequiresAuthentication && this.m_PromptForPassword && this.m_Password.getValue().length() == 0) {
            if (!this.isHeadless()) {
                if (!this.doInteract() && this.m_StopFlowIfCanceled) {
                    if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                    } else {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                    }
                    result = this.getStopMessage();
                }
            } else if (this.supportsHeadlessInteraction() && !this.doInteractHeadless() && this.m_StopFlowIfCanceled) {
                if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                    StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                } else {
                    StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                }
                result = this.getStopMessage();
            }
        }
        return result;
    }
}

