/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.License;
import adams.core.QuickInfoHelper;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.annotation.MixedCopyright;
import adams.core.base.BasePassword;
import adams.core.io.ConsoleHelper;
import adams.core.io.PlaceholderFile;
import adams.core.net.JSchUtils;
import adams.core.net.SSHAuthenticationType;
import adams.core.net.SSHSessionProvider;
import adams.core.option.OptionHandler;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.OptionalPasswordPrompt;
import adams.flow.core.StopHelper;
import adams.flow.core.StopMode;
import adams.flow.standalone.AbstractStandalone;
import adams.gui.dialog.PasswordDialog;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;

@MixedCopyright(copyright="JCraft", license=License.BSD3, url="http://www.jcraft.com/jsch/")
public class SSHConnection
extends AbstractStandalone
implements TechnicalInformationHandler,
OptionalPasswordPrompt,
SSHSessionProvider {
    private static final long serialVersionUID = -1959430342987913960L;
    protected String m_Host;
    protected int m_Port;
    protected SSHAuthenticationType m_AuthenticationType;
    protected String m_User;
    protected BasePassword m_Password;
    protected PlaceholderFile m_PrivateKeyFile;
    protected BasePassword m_PrivateKeyPassphrase;
    protected PlaceholderFile m_KnownHosts;
    protected boolean m_StrictHostKeyChecking;
    protected boolean m_ForwardX;
    protected String m_XHost;
    protected int m_XPort;
    protected BasePassword m_ActualPassword;
    protected boolean m_PromptForPassword;
    protected boolean m_StopFlowIfCanceled;
    protected String m_CustomStopMessage;
    protected StopMode m_StopMode;
    protected transient Session m_Session;

    public String globalInfo() {
        return "Provides access to a remote host via SSH.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.TITLE, "JSch - JSch is a pure Java implementation of SSH2.");
        result.setValue(TechnicalInformation.Field.HTTP, "http://www.jcraft.com/jsch/");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"");
        this.m_OptionManager.add("port", "port", (Object)22, (Number)1, (Number)65535);
        this.m_OptionManager.add("authentication-type", "authenticationType", (Object)SSHAuthenticationType.CREDENTIALS);
        this.m_OptionManager.add("user", "user", (Object)System.getProperty("user.name"), false);
        this.m_OptionManager.add("password", "password", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("private-key-file", "privateKeyFile", (Object)new PlaceholderFile(System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "id_rsa"));
        this.m_OptionManager.add("private-key-passphrase", "privateKeyPassphrase", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("known-hosts", "knownHosts", (Object)new PlaceholderFile(System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "known_hosts"));
        this.m_OptionManager.add("strict-host-key-checking", "strictHostKeyChecking", (Object)true);
        this.m_OptionManager.add("forward-x", "forwardX", (Object)false);
        this.m_OptionManager.add("x-host", "XHost", (Object)"");
        this.m_OptionManager.add("x-port", "XPort", (Object)6000, (Number)1, (Number)65535);
        this.m_OptionManager.add("prompt-for-password", "promptForPassword", (Object)false);
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", (Object)false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", (Object)"");
        this.m_OptionManager.add("stop-mode", "stopMode", (Object)StopMode.GLOBAL);
    }

    protected void reset() {
        super.reset();
        this.disconnect();
    }

    public String getQuickInfo() {
        String result;
        if (this.m_AuthenticationType == SSHAuthenticationType.CREDENTIALS) {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"user", (Object)this.m_User);
            String value = QuickInfoHelper.toString((OptionHandler)this, (String)"password", (Object)this.m_Password.getValue().replaceAll(".", "*"));
            if (value != null) {
                result = result + ":" + value;
            }
        } else {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"privateKeyFile", (Object)this.m_PrivateKeyFile);
        }
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"host", (Object)(this.m_Host.length() == 0 ? "??" : this.m_Host), (String)"@");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"port", (Object)this.m_Port, (String)":");
        ArrayList options = new ArrayList();
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"promptForPassword") || this.m_PromptForPassword) {
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"promptForPassword", (boolean)this.m_PromptForPassword, (String)"prompt for password"));
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"stopFlowIfCanceled", (boolean)this.m_StopFlowIfCanceled, (String)"stop flow"));
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"strictHostKeyChecking", (boolean)this.m_StrictHostKeyChecking, (String)"strict hostkey"));
        }
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setHost(String value) {
        this.m_Host = value;
        this.reset();
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host (name/IP address) to connect to.";
    }

    public void setPort(int value) {
        if (this.getOptionManager().isValid("port", (Number)value)) {
            this.m_Port = value;
            this.reset();
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public String portTipText() {
        return "The port to connect to.";
    }

    public void setAuthenticationType(SSHAuthenticationType value) {
        this.m_AuthenticationType = value;
        this.reset();
    }

    public SSHAuthenticationType getAuthenticationType() {
        return this.m_AuthenticationType;
    }

    public String authenticationTypeTipText() {
        return "The type of authentication to use.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The SSH user to use for connecting.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the SSH user to use for connecting.";
    }

    public void setPrivateKeyFile(PlaceholderFile value) {
        this.m_PrivateKeyFile = value;
        this.reset();
    }

    public PlaceholderFile getPrivateKeyFile() {
        return this.m_PrivateKeyFile;
    }

    public String privateKeyFileTipText() {
        return "The location of the private key.";
    }

    public void setPrivateKeyPassphrase(BasePassword value) {
        this.m_PrivateKeyPassphrase = value;
        this.reset();
    }

    public BasePassword getPrivateKeyPassphrase() {
        return this.m_PrivateKeyPassphrase;
    }

    public String privateKeyPassphraseTipText() {
        return "The passphrase for the private key file, ignored if empty.";
    }

    public void setKnownHosts(PlaceholderFile value) {
        this.m_KnownHosts = value;
        this.reset();
    }

    public PlaceholderFile getKnownHosts() {
        return this.m_KnownHosts;
    }

    public String knownHostsTipText() {
        return "The file storing the known hosts.";
    }

    public void setStrictHostKeyChecking(boolean value) {
        this.m_StrictHostKeyChecking = value;
        this.reset();
    }

    public boolean getStrictHostKeyChecking() {
        return this.m_StrictHostKeyChecking;
    }

    public String strictHostKeyCheckingTipText() {
        return "Enables/disables strict host key checking - strict checking is the recommended setting, as disabling it is very insecure!";
    }

    public void setForwardX(boolean value) {
        this.m_ForwardX = value;
        this.reset();
    }

    public boolean getForwardX() {
        return this.m_ForwardX;
    }

    public String forwardXTipText() {
        return "If set to true, then X is forwarded.";
    }

    public void setXHost(String value) {
        this.m_XHost = value;
        this.reset();
    }

    public String getXHost() {
        return this.m_XHost;
    }

    public String XHostTipText() {
        return "The xhost (name/IP address) to connect to.";
    }

    public void setXPort(int value) {
        if (this.getOptionManager().isValid("XPort", (Number)value)) {
            this.m_XPort = value;
            this.reset();
        }
    }

    public int getXPort() {
        return this.m_XPort;
    }

    public String XPortTipText() {
        return "The xport to connect to.";
    }

    public void setPromptForPassword(boolean value) {
        this.m_PromptForPassword = value;
        this.reset();
    }

    public boolean getPromptForPassword() {
        return this.m_PromptForPassword;
    }

    public String promptForPasswordTipText() {
        return "If enabled, the user gets prompted for enter a password if none has been provided in the setup.";
    }

    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    public void setStopMode(StopMode value) {
        this.m_StopMode = value;
        this.reset();
    }

    public StopMode getStopMode() {
        return this.m_StopMode;
    }

    public String stopModeTipText() {
        return "The stop mode to use.";
    }

    public boolean doInteract() {
        boolean result;
        PasswordDialog dlg = new PasswordDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL);
        dlg.setLocationRelativeTo(this.getParentComponent());
        ((Flow)this.getRoot()).registerWindow((Window)dlg, dlg.getTitle());
        dlg.setVisible(true);
        ((Flow)this.getRoot()).deregisterWindow((Window)dlg);
        boolean bl = result = dlg.getOption() == 0;
        if (result) {
            this.m_ActualPassword = dlg.getPassword();
        }
        return result;
    }

    public boolean supportsHeadlessInteraction() {
        return true;
    }

    public boolean doInteractHeadless() {
        boolean result = false;
        BasePassword password = ConsoleHelper.enterPassword((String)("Please enter password (" + this.getName() + "):"));
        if (password != null) {
            result = true;
            this.m_ActualPassword = password;
        }
        return result;
    }

    @Override
    public synchronized Session getSession() {
        return this.m_Session;
    }

    @Override
    public Session newSession() {
        return this.newSession(this.m_Host, this.m_Port);
    }

    @Override
    public Session newSession(String host, int port) {
        Session result;
        String password = this.m_ActualPassword.getValue();
        try {
            JSch jsch = JSchUtils.newJsch((File)this.m_KnownHosts);
            switch (this.m_AuthenticationType) {
                case CREDENTIALS: {
                    result = JSchUtils.newSession(jsch, this.m_User, password, host, port);
                    break;
                }
                case PUBLIC_KEY: {
                    result = JSchUtils.newSession(jsch, this.m_User, (File)this.m_PrivateKeyFile, password, host, port);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled authentication type: " + (Object)((Object)this.m_AuthenticationType));
                }
            }
            JSchUtils.configureStrictHostKeyChecking(result, this.m_StrictHostKeyChecking);
            if (this.m_ForwardX) {
                JSchUtils.configureX11(result, this.m_XHost, this.m_XPort);
            }
            result.connect();
        }
        catch (Exception e) {
            this.handleException("Failed to establish connection to '" + host + "' (using " + (Object)((Object)this.m_AuthenticationType) + "): ", e);
            result = null;
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Session == null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Starting new session");
            }
            switch (this.m_AuthenticationType) {
                case CREDENTIALS: {
                    this.m_ActualPassword = this.m_Password;
                    break;
                }
                case PUBLIC_KEY: {
                    this.m_ActualPassword = this.m_PrivateKeyPassphrase;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled authentication type: " + (Object)((Object)this.m_AuthenticationType));
                }
            }
            if (this.m_PromptForPassword && this.m_Password.getValue().length() == 0) {
                if (!this.isHeadless()) {
                    if (!this.doInteract() && this.m_StopFlowIfCanceled) {
                        if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                            StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                        } else {
                            StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                        }
                        result = this.getStopMessage();
                    }
                } else if (this.supportsHeadlessInteraction() && !this.doInteractHeadless() && this.m_StopFlowIfCanceled) {
                    if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                    } else {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                    }
                    result = this.getStopMessage();
                }
            }
            if (result == null) {
                if (!this.m_Host.isEmpty()) {
                    this.m_Session = this.newSession();
                    if (this.m_Session == null) {
                        result = "Failed to connect to '" + this.m_Host + "' as user '" + this.m_User + "'!";
                    }
                } else {
                    this.getLogger().warning("No host supplied, not initiating session!");
                }
            }
        } else if (this.isLoggingEnabled()) {
            this.getLogger().info("Re-using current session");
        }
        return result;
    }

    protected void disconnect() {
        if (this.m_Session != null && this.m_Session.isConnected()) {
            try {
                this.m_Session.disconnect();
            }
            catch (Exception e) {
                this.handleException("Failed to disconnect from '" + this.m_Host + "':", e);
            }
        }
        this.m_Session = null;
    }

    public void wrapUp() {
        this.disconnect();
        super.wrapUp();
    }
}

