/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseCharset;
import adams.core.base.BaseKeyValuePair;
import adams.core.base.BaseURL;
import adams.core.io.EncodingSupporter;
import adams.core.net.HttpRequestHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.HTMLRequestResult;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import org.jsoup.Connection;

public class HttpRequest
extends AbstractTransformer
implements EncodingSupporter {
    private static final long serialVersionUID = 3114594997972970790L;
    protected BaseURL m_URL;
    protected Connection.Method m_Method;
    protected BaseKeyValuePair[] m_Headers;
    protected BaseCharset m_Encoding;

    public String globalInfo() {
        return "Sends the incoming text/bytes payload to the specified URL (with optional HTTP headers) and forwards the retrieved HTML as text.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)new BaseURL());
        this.m_OptionManager.add("method", "method", (Object)Connection.Method.POST);
        this.m_OptionManager.add("header", "headers", (Object)new BaseKeyValuePair[0]);
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset("UTF-8"));
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"URL", (Object)this.m_URL, (String)"URL: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"method", (Object)this.m_Method, (String)", method: ");
        return result;
    }

    public void setURL(BaseURL value) {
        this.m_URL = value;
        this.reset();
    }

    public BaseURL getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The URL for the request.";
    }

    public void setMethod(Connection.Method value) {
        this.m_Method = value;
        this.reset();
    }

    public Connection.Method getMethod() {
        return this.m_Method;
    }

    public String methodTipText() {
        return "The method to use for the request.";
    }

    public void setHeaders(BaseKeyValuePair[] value) {
        this.m_Headers = value;
        this.reset();
    }

    public BaseKeyValuePair[] getHeaders() {
        return this.m_Headers;
    }

    public String headersTipText() {
        return "The (optional) request headers to send.";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use for incoming strings.";
    }

    public Class[] accepts() {
        return new Class[]{byte[].class, String.class};
    }

    public Class[] generates() {
        return new Class[]{HTMLRequestResult.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            HTMLRequestResult cont = this.m_InputToken.hasPayload(String.class) ? HttpRequestHelper.send(this.m_URL, this.m_Method, this.m_Headers, (String)this.m_InputToken.getPayload(), this.m_Encoding.stringValue()) : HttpRequestHelper.send(this.m_URL, this.m_Method, this.m_Headers, (byte[])this.m_InputToken.getPayload());
            this.m_OutputToken = new Token((Object)cont);
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute request: " + this.m_URL, e);
        }
        return result;
    }
}

