/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.websocket.server;

import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.flow.websocket.server.AbstractWebSocketServerGenerator;
import adams.flow.websocket.server.EchoServer;
import com.pusher.java_websocket.server.WebSocketServer;
import java.net.InetSocketAddress;

public class EchoServerGenerator
extends AbstractWebSocketServerGenerator {
    private static final long serialVersionUID = -3871912816817034765L;
    protected int m_Port;

    public String globalInfo() {
        return "Generates a simple echo server which just sends the messages back to the client.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("port", "port", (Object)8000, (Number)1, (Number)65535);
    }

    public void setPort(int value) {
        if (this.getOptionManager().isValid("port", (Number)value)) {
            this.m_Port = value;
            this.reset();
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public String portTipText() {
        return "The port to connect to.";
    }

    @Override
    protected WebSocketServer doGenerate() {
        Logger logger = LoggingHelper.getLogger(EchoServer.class);
        logger.setLevel(this.getLoggingLevel().getLevel());
        return new EchoServer(new InetSocketAddress(this.m_Port), logger);
    }
}

