/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.net.Email;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTable;
import adams.gui.core.BaseTextArea;
import adams.gui.core.BaseTextField;
import adams.gui.core.KeyValuePairTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class DisplayEmailPanel
extends BasePanel {
    private static final long serialVersionUID = 8638983030175738046L;
    protected Email m_Email;
    protected BaseTextField m_TextSender;
    protected BaseTable m_TableRecipients;
    protected KeyValuePairTableModel m_ModelRecipients;
    protected BaseScrollPane m_ScrollPaneRecipients;
    protected BaseTextField m_TextSubject;
    protected BaseTextArea m_TextBody;
    protected BaseTable m_TableAttachments;
    protected KeyValuePairTableModel m_ModelAttachments;
    protected BaseScrollPane m_ScrollPaneAttachments;

    protected void initialize() {
        super.initialize();
        this.m_Email = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panelTop = new JPanel(new BorderLayout());
        this.add(panelTop, "North");
        this.m_TextSender = new BaseTextField(40);
        this.m_TextSender.setEditable(false);
        JLabel label = new JLabel("From");
        label.setDisplayedMnemonic('F');
        label.setLabelFor((Component)this.m_TextSender);
        JPanel panel = new JPanel(new FlowLayout(0));
        panelTop.add((Component)panel, "North");
        panel.add(label);
        panel.add((Component)this.m_TextSender);
        this.m_ModelRecipients = new KeyValuePairTableModel((Object[][])new String[0][], this.getHeaderRecipients());
        this.m_TableRecipients = new BaseTable((TableModel)this.m_ModelRecipients);
        this.m_TableRecipients.setAutoResizeMode(0);
        this.m_ScrollPaneRecipients = new BaseScrollPane((Component)this.m_TableRecipients);
        this.m_ScrollPaneRecipients.setPreferredSize(new Dimension(0, 125));
        panelTop.add((Component)this.m_ScrollPaneRecipients, "Center");
        this.m_TextSubject = new BaseTextField(40);
        this.m_TextSubject.setEditable(false);
        label = new JLabel("Subject");
        label.setDisplayedMnemonic('S');
        label.setLabelFor((Component)this.m_TextSubject);
        panel = new JPanel(new FlowLayout(0));
        panelTop.add((Component)panel, "South");
        panel.add(label);
        panel.add((Component)this.m_TextSubject);
        this.m_TextBody = new BaseTextArea(5, 40);
        this.m_TextBody.setEditable(false);
        this.add((Component)new BaseScrollPane((Component)this.m_TextBody), "Center");
        this.m_ModelAttachments = new KeyValuePairTableModel((Object[][])new String[0][], this.getHeaderAttachments());
        this.m_TableAttachments = new BaseTable((TableModel)this.m_ModelAttachments);
        this.m_TableAttachments.setAutoResizeMode(0);
        this.m_ScrollPaneAttachments = new BaseScrollPane((Component)this.m_TableAttachments);
        this.m_ScrollPaneAttachments.setPreferredSize(new Dimension(0, 75));
        this.add((Component)this.m_ScrollPaneAttachments, "South");
    }

    protected void finishInit() {
        super.finishInit();
        this.update();
        this.doLayout();
        this.m_TableRecipients.getPreferredSize().height = 100;
        this.m_TableAttachments.getPreferredSize().height = 50;
        this.doLayout();
    }

    public void setEmail(Email value) {
        this.m_Email = value;
        this.update();
    }

    public Email getEmail() {
        return this.m_Email;
    }

    protected String[] getHeaderRecipients() {
        return new String[]{"Type", "Address"};
    }

    protected String[] getHeaderAttachments() {
        return new String[]{"Index", "Attachment"};
    }

    protected void update() {
        if (this.m_Email == null) {
            this.m_TextSender.setText("");
            this.m_ModelRecipients = new KeyValuePairTableModel((Object[][])new String[0][], this.getHeaderRecipients());
            this.m_TableRecipients.setModel((TableModel)this.m_ModelRecipients);
            this.m_TextSubject.setText("(no subject)");
            this.m_TextBody.setText("");
            this.m_ModelAttachments = new KeyValuePairTableModel((Object[][])new String[0][], this.getHeaderAttachments());
            this.m_TableAttachments.setModel((TableModel)this.m_ModelAttachments);
        } else {
            int i;
            this.m_TextSender.setText(this.m_Email.getFrom().getValue());
            Object[][] recipients = new String[this.m_Email.getTo().length + this.m_Email.getCC().length + this.m_Email.getBCC().length][2];
            int offset = 0;
            for (i = 0; i < this.m_Email.getTo().length; ++i) {
                recipients[offset + i][0] = "To";
                recipients[offset + i][1] = this.m_Email.getTo()[i].getValue();
            }
            offset += this.m_Email.getTo().length;
            for (i = 0; i < this.m_Email.getCC().length; ++i) {
                recipients[offset + i][0] = "CC";
                recipients[offset + i][1] = this.m_Email.getCC()[i].getValue();
            }
            offset += this.m_Email.getCC().length;
            for (i = 0; i < this.m_Email.getBCC().length; ++i) {
                recipients[offset + i][0] = "BCC";
                recipients[offset + i][1] = this.m_Email.getBCC()[i].getValue();
            }
            this.m_ModelRecipients = new KeyValuePairTableModel(recipients, this.getHeaderRecipients());
            this.m_TableRecipients.setModel((TableModel)this.m_ModelRecipients);
            this.m_TextSubject.setText(this.m_Email.getSubject());
            this.m_TextBody.setText(this.m_Email.getBody());
            Object[][] attachments = new String[this.m_Email.getAttachments().length][2];
            for (i = 0; i < this.m_Email.getAttachments().length; ++i) {
                attachments[i][0] = "" + (i + 1);
                attachments[i][1] = this.m_Email.getAttachments()[i].toString();
            }
            this.m_ModelAttachments = new KeyValuePairTableModel(attachments, this.getHeaderAttachments());
            this.m_TableAttachments.setModel((TableModel)this.m_ModelAttachments);
        }
        this.m_TableRecipients.setOptimalColumnWidth();
        this.m_TableAttachments.setOptimalColumnWidth();
    }
}

