/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.lister;

import adams.core.PasswordSupporter;
import adams.core.base.BasePassword;
import adams.core.io.FileObject;
import adams.core.io.SmbFileObject;
import adams.core.io.lister.AbstractRecursiveDirectoryLister;
import adams.core.io.lister.SortContainer;
import adams.core.io.lister.Sorting;
import adams.core.net.SMBAuthenticationProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;

public class SmbDirectoryLister
extends AbstractRecursiveDirectoryLister
implements PasswordSupporter {
    private static final long serialVersionUID = 2687222234652386893L;
    protected String m_Host;
    protected String m_Domain;
    protected String m_User;
    protected BasePassword m_Password;
    protected SMBAuthenticationProvider m_AuthenticationProvider;
    protected transient NtlmPasswordAuthentication m_Authentication;

    public void setHost(String value) {
        this.m_Host = value;
    }

    public String getHost() {
        return this.m_Host;
    }

    public void setDomain(String value) {
        this.m_Domain = value;
    }

    public String getDomain() {
        return this.m_Domain;
    }

    public void setUser(String value) {
        this.m_User = value;
    }

    public String getUser() {
        return this.m_User;
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public void setAuthenticationProvider(SMBAuthenticationProvider value) {
        this.m_AuthenticationProvider = value;
    }

    public SMBAuthenticationProvider getAuthenticationProvider() {
        return this.m_AuthenticationProvider;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean hasParentDirectory() {
        return new File(this.m_WatchDir).getParentFile() != null;
    }

    public SmbFileObject newDirectory(String dir) {
        return this.newDirectory(this.m_WatchDir, dir);
    }

    public SmbFileObject newDirectory(String parent, String dir) {
        try {
            String pdir = parent;
            if (!pdir.startsWith("/")) {
                pdir = "/" + pdir;
            }
            if (!pdir.endsWith("/")) {
                pdir = pdir + "/";
            }
            if (!dir.endsWith("/")) {
                dir = dir + dir;
            }
            return new SmbFileObject(new SmbFile("smb://" + this.m_Host + pdir + dir));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void search(SmbFile context, List<SortContainer> files, int depth) throws Exception {
        SmbFile[] currFiles;
        if (depth == 0) {
            return;
        }
        if (this.getDebug()) {
            this.getLogger().info("search: context=" + context + ", depth=" + depth);
        }
        if ((currFiles = context.listFiles()) == null) {
            if (this.getDebug()) {
                this.getLogger().info("No files listed!");
            }
            return;
        }
        for (int i = 0; i < currFiles.length && !this.m_Stopped; ++i) {
            SmbFile entry = currFiles[i];
            if (entry.isDirectory()) {
                if (entry.getName().equals(".") || entry.getName().equals("..")) continue;
                if (this.m_Recursive) {
                    this.search(entry, files, depth - 1);
                }
                if (!this.m_ListDirs || !this.m_RegExp.isEmpty() && !this.m_RegExp.isMatch(entry.getName())) continue;
                files.add(new SortContainer((FileObject)new SmbFileObject(entry), this.m_Sorting));
                continue;
            }
            if (!this.m_ListFiles || !this.m_RegExp.isEmpty() && !this.m_RegExp.isMatch(entry.getName())) continue;
            files.add(new SortContainer((FileObject)new SmbFileObject(entry), this.m_Sorting));
        }
    }

    public List<SmbFileObject> search(SmbFile context) throws Exception {
        ArrayList<SmbFileObject> result = new ArrayList<SmbFileObject>();
        this.m_Stopped = false;
        if (this.m_ListFiles || this.m_ListDirs) {
            int i;
            if (this.getDebug()) {
                this.getLogger().info("watching '" + this.m_WatchDir + "'");
            }
            if (this.getDebug()) {
                this.getLogger().info("before search(...)");
            }
            ArrayList<SortContainer> list = new ArrayList<SortContainer>();
            this.search(context, list, this.m_MaxDepth);
            if (this.getDebug()) {
                this.getLogger().info("before obtaining last modified timestamps");
            }
            if (!this.m_Stopped && this.m_Sorting != Sorting.NO_SORTING) {
                if (this.getDebug()) {
                    this.getLogger().info("before sorting");
                }
                Collections.sort(list);
                if (this.m_SortDescending) {
                    for (i = 0; i < list.size() / 2; ++i) {
                        SortContainer cont = (SortContainer)list.get(i);
                        list.set(i, (SortContainer)list.get(list.size() - 1 - i));
                        list.set(list.size() - 1 - i, cont);
                    }
                }
            }
            if (!this.m_Stopped) {
                if (this.getDebug()) {
                    this.getLogger().info("before matching");
                }
                for (i = 0; i < list.size(); ++i) {
                    result.add((SmbFileObject)((SortContainer)list.get(i)).getFile());
                    if (this.m_MaxItems > 0 && result.size() == this.m_MaxItems) {
                        if (!this.getDebug()) break;
                        this.getLogger().info("max size reached");
                        break;
                    }
                    if (this.m_Stopped) break;
                }
            }
        }
        if (this.m_Stopped) {
            result.clear();
        }
        return result;
    }

    public String[] list() {
        SmbFileObject[] wrappers = this.listObjects();
        String[] result = new String[wrappers.length];
        for (int i = 0; i < wrappers.length; ++i) {
            result[i] = wrappers[i].toString();
        }
        return result;
    }

    public SmbFileObject[] listObjects() {
        ArrayList<SmbFileObject> result = new ArrayList<SmbFileObject>();
        this.m_Stopped = false;
        if (this.m_Authentication == null) {
            this.m_Authentication = this.m_AuthenticationProvider != null ? this.m_AuthenticationProvider.getAuthentication() : new NtlmPasswordAuthentication(this.m_Domain, this.m_User, this.m_Password.getValue());
        }
        try {
            String dir = this.m_WatchDir;
            if (!dir.startsWith("/")) {
                dir = "/" + dir;
            }
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            SmbFile context = new SmbFile("smb://" + this.m_Host + dir, this.m_Authentication);
            result.addAll(this.search(context));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to create search context!", (Throwable)e);
        }
        return result.toArray(new SmbFileObject[result.size()]);
    }
}

