/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.base.AbstractBaseString;
import javax.mail.internet.InternetAddress;

public class EmailAddress
extends AbstractBaseString {
    private static final long serialVersionUID = -8687858764646783666L;
    public static final String DUMMY_ADDRESS = "john.doe@nowhere.org";

    public EmailAddress() {
        this(DUMMY_ADDRESS);
    }

    public EmailAddress(String s) {
        super(s);
    }

    protected void initialize() {
        this.m_Internal = DUMMY_ADDRESS;
    }

    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            if (value.indexOf(64) == -1) {
                return false;
            }
            new InternetAddress(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isDummyAddress() {
        return this.getValue().equals(DUMMY_ADDRESS);
    }

    public String getTipText() {
        return "Email address.";
    }

    public String strippedValue() {
        String result = this.getValue();
        if (result == null) {
            return "";
        }
        if (this.getValue().indexOf(60) == -1) {
            return result;
        }
        return result.substring(result.lastIndexOf(60) + 1, result.lastIndexOf(62));
    }

    public boolean hasFavoritesSupport() {
        return true;
    }
}

