/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.selection;

import adams.core.net.EmailAddressBook;
import adams.core.net.EmailContact;
import adams.core.option.OptionUtils;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.SearchParameters;
import adams.gui.selection.AbstractTableBasedSelectionPanel;
import adams.gui.tools.EmailAddressBookPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectEmailAddressPanel
extends AbstractTableBasedSelectionPanel<EmailContact> {
    private static final long serialVersionUID = 8172361673639083461L;
    protected JLabel m_LabelManualAddresses;
    protected BaseTextField m_TextManualAddresses;
    protected BaseButton m_ButtonAddressBook;

    protected void initGUI() {
        super.initGUI();
        this.m_TableData.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SelectEmailAddressPanel.this.m_TableData.getSelectedRowCount() > 0) {
                    SelectEmailAddressPanel.this.m_TextManualAddresses.setText("");
                }
            }
        });
        this.m_TextManualAddresses = new BaseTextField(15);
        this.m_LabelManualAddresses = new JLabel();
        this.m_LabelManualAddresses.setLabelFor(this.m_LabelManualAddresses);
        this.m_ButtonAddressBook = new BaseButton("Addressbook");
        this.m_ButtonAddressBook.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectEmailAddressPanel.this.openAddressBook();
            }
        });
        this.m_SearchPanel.addToWidgetsPanel((Component)this.m_LabelManualAddresses);
        this.m_SearchPanel.addToWidgetsPanel((Component)this.m_TextManualAddresses);
        this.m_SearchPanel.addToWidgetsPanel((Component)this.m_ButtonAddressBook);
        this.setMultipleSelection(this.isMultipleSelection());
        this.m_TableData.setOptimalColumnWidth();
    }

    protected void finishInit() {
        super.finishInit();
        this.reload();
    }

    protected AbstractTableBasedSelectionPanel.AbstractSelectionTableModel<EmailContact> newTableModel() {
        return new TableModel();
    }

    protected Class getItemClass() {
        return EmailContact.class;
    }

    protected boolean addToMissing(EmailContact item) {
        if (item.getEmail().trim().length() == 0) {
            return false;
        }
        if (item.getEmail().equals("john.doe@nowhere.org")) {
            return false;
        }
        return super.addToMissing((Object)item);
    }

    protected void processMissing(List<EmailContact> missing) {
        if (this.isMultipleSelection()) {
            String[] list = new String[missing.size()];
            for (int i = 0; i < missing.size(); ++i) {
                list[i] = missing.get(i).toString();
            }
            this.m_TextManualAddresses.setText(OptionUtils.joinOptions((String[])list));
        } else {
            this.m_TextManualAddresses.setText(missing.get(0).toString());
        }
    }

    protected EmailContact[] getCurrentItems() {
        EmailContact[] result;
        if (this.m_TextManualAddresses.getText().length() > 0) {
            try {
                String[] addresses = this.isMultipleSelection() ? OptionUtils.splitOptions((String)this.m_TextManualAddresses.getText()) : new String[]{this.m_TextManualAddresses.getText()};
                result = (EmailContact[])Array.newInstance(this.getItemClass(), addresses.length);
                for (int i = 0; i < addresses.length; ++i) {
                    result[i] = new EmailContact();
                    result[i].setEmail(addresses[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
        } else {
            result = (EmailContact[])super.getCurrentItems();
        }
        return result;
    }

    public void setMultipleSelection(boolean value) {
        super.setMultipleSelection(value);
        if (value) {
            this.m_LabelManualAddresses.setText("Manual addresses");
        } else {
            this.m_LabelManualAddresses.setText("Manual address");
        }
    }

    protected void reload() {
        this.m_TableDataModel = new TableModel(EmailAddressBook.getSingleton().getContacts());
        this.m_TableData.setModel((javax.swing.table.TableModel)this.m_TableDataModel);
        this.m_TableData.setOptimalColumnWidth();
    }

    protected void openAddressBook() {
        BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new BaseDialog(this.getParentFrame(), true);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Email addressbook");
        EmailAddressBookPanel panel = new EmailAddressBookPanel();
        dialog.getContentPane().add((Component)((Object)panel), "Center");
        dialog.setSize(GUIHelper.getInteger((String)"DefaultDialog.Width", (Integer)800).intValue(), GUIHelper.getInteger((String)"DefaultDialog.Width", (Integer)800).intValue());
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        this.reload();
    }

    public static class TableModel
    extends AbstractTableBasedSelectionPanel.AbstractSelectionTableModel<EmailContact> {
        private static final long serialVersionUID = 6097860917524908958L;
        protected List<EmailContact> m_Values = new ArrayList<EmailContact>();

        public TableModel() {
        }

        public TableModel(List<EmailContact> contacts) {
            this();
            this.m_Values.addAll(contacts);
        }

        public TableModel(EmailContact[] contacts) {
            this();
            this.m_Values.addAll(Arrays.asList(contacts));
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return "First";
            }
            if (column == 1) {
                return "Last";
            }
            if (column == 2) {
                return "Email";
            }
            if (column == 3) {
                return "Phone";
            }
            if (column == 4) {
                return "Address";
            }
            if (column == 5) {
                return "Note";
            }
            throw new IllegalArgumentException("Column " + column + " is invalid!");
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            if (columnIndex == 2) {
                return String.class;
            }
            if (columnIndex == 3) {
                return String.class;
            }
            if (columnIndex == 4) {
                return String.class;
            }
            if (columnIndex == 5) {
                return String.class;
            }
            throw new IllegalArgumentException("Column " + columnIndex + " is invalid!");
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.m_Values.get(row).getFirstName();
            }
            if (column == 1) {
                return this.m_Values.get(row).getLastName();
            }
            if (column == 2) {
                return this.m_Values.get(row).getEmail();
            }
            if (column == 3) {
                return this.m_Values.get(row).getPhone();
            }
            if (column == 4) {
                return this.m_Values.get(row).getAddress();
            }
            if (column == 5) {
                return this.m_Values.get(row).getNote();
            }
            throw new IllegalArgumentException("Column " + column + " is invalid!");
        }

        public boolean isSearchMatch(SearchParameters params, int row) {
            if (params.matches(this.m_Values.get(row).getEmail())) {
                return true;
            }
            if (params.matches(this.m_Values.get(row).getFirstName())) {
                return true;
            }
            if (params.matches(this.m_Values.get(row).getLastName())) {
                return true;
            }
            if (params.matches(this.m_Values.get(row).getNote())) {
                return true;
            }
            if (params.matches(this.m_Values.get(row).getPhone())) {
                return true;
            }
            return params.matches(this.m_Values.get(row).getAddress());
        }

        public int getRowCount() {
            return this.m_Values.size();
        }

        public EmailContact getItemAt(int row) {
            return this.m_Values.get(row);
        }

        public int indexOf(EmailContact item) {
            int result = -1;
            for (int i = 0; i < this.m_Values.size(); ++i) {
                if (!this.m_Values.get(i).getEmail().equals(item.getEmail())) continue;
                result = i;
                break;
            }
            return result;
        }
    }
}

