/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.FileObject;
import adams.core.io.FileUtils;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Date;

public class SftpFileObject
implements FileObject {
    private static final long serialVersionUID = -1391761454087211261L;
    protected transient Session m_Session;
    protected File m_ParentDir;
    protected String m_Name;
    protected Boolean m_Directory;
    protected transient ChannelSftp.LsEntry m_Entry;

    public SftpFileObject(File parentDir, String name, boolean dir, Session session) {
        this(parentDir, null, name, dir, session);
    }

    public SftpFileObject(File parentDir, ChannelSftp.LsEntry entry, Session session) {
        this(parentDir, entry, null, null, session);
    }

    protected SftpFileObject(File parentDir, ChannelSftp.LsEntry entry, String name, Boolean dir, Session session) {
        this.m_ParentDir = parentDir;
        this.m_Entry = entry;
        this.m_Name = name;
        this.m_Directory = dir;
        this.m_Session = session;
    }

    public Session getSession() {
        return this.m_Session;
    }

    public File getParentDir() {
        return this.m_ParentDir;
    }

    public File getFile() {
        if (this.m_Entry != null) {
            return new File(this.m_ParentDir + "/" + this.m_Entry.getFilename());
        }
        return new File(this.m_ParentDir + "/" + this.m_Name);
    }

    public File getActualFile() {
        return this.getFile();
    }

    public String getName() {
        if (this.m_Entry != null) {
            return this.m_Entry.getFilename();
        }
        return this.m_Name;
    }

    public long getLength() {
        if (this.m_Entry != null) {
            return this.m_Entry.getAttrs().getSize();
        }
        return -1L;
    }

    public boolean isDirectory() {
        if (this.m_Entry != null) {
            return this.m_Entry.getAttrs().isDir();
        }
        return this.m_Directory;
    }

    public Date getLastModified() {
        if (this.m_Entry != null) {
            return new Date((long)this.m_Entry.getAttrs().getMTime() * 1000L);
        }
        return new Date(0L);
    }

    public boolean isHidden() {
        return this.getName().startsWith(".");
    }

    public boolean isLink() {
        if (this.m_Entry != null) {
            return this.m_Entry.getAttrs().isLink();
        }
        return false;
    }

    public boolean isLocal() {
        return false;
    }

    public String toString() {
        return FileUtils.useForwardSlashes((String)this.getFile().toString());
    }

    public int compareTo(FileObject o) {
        return this.getFile().compareTo(o.getFile());
    }

    public boolean equals(Object obj) {
        return obj instanceof FileObject && this.compareTo((FileObject)obj) == 0;
    }
}

