/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.FileObject;
import java.io.File;
import java.util.Date;
import jcifs.smb.SmbFile;

public class SmbFileObject
implements FileObject {
    private static final long serialVersionUID = -1391761454087211261L;
    protected SmbFile m_File;
    protected Long m_Length;
    protected Boolean m_Directory;
    protected Date m_LastModified;
    protected Boolean m_Hidden;

    public SmbFileObject(SmbFile file) {
        this.m_File = file;
    }

    public File getFile() {
        return new File(this.m_File.getUncPath());
    }

    public File getActualFile() {
        return this.getFile();
    }

    public String getName() {
        return this.m_File.getName();
    }

    public synchronized long getLength() {
        if (this.m_Length == null) {
            try {
                this.m_Length = this.m_File.length();
            }
            catch (Exception e) {
                this.m_Length = -1L;
            }
        }
        return this.m_Length;
    }

    public synchronized boolean isDirectory() {
        if (this.m_Directory == null) {
            try {
                this.m_Directory = this.m_File.isDirectory();
            }
            catch (Exception e) {
                this.m_Directory = false;
            }
        }
        return this.m_Directory;
    }

    public synchronized Date getLastModified() {
        if (this.m_LastModified == null) {
            try {
                this.m_LastModified = new Date(this.m_File.lastModified());
            }
            catch (Exception e) {
                this.m_LastModified = new Date(0L);
            }
        }
        return this.m_LastModified;
    }

    public synchronized boolean isHidden() {
        if (this.m_Hidden == null) {
            try {
                this.m_Hidden = this.m_File.isHidden();
            }
            catch (Exception e) {
                this.m_Hidden = false;
            }
        }
        return this.m_Hidden;
    }

    public boolean isLink() {
        return false;
    }

    public boolean isLocal() {
        return false;
    }

    public String toString() {
        return this.m_File.toString();
    }

    public int compareTo(FileObject o) {
        return this.getFile().compareTo(o.getFile());
    }

    public boolean equals(Object obj) {
        return obj instanceof FileObject && this.compareTo((FileObject)obj) == 0;
    }
}

