/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.ShallowCopySupporter;
import adams.core.Utils;
import adams.core.net.EmailAddress;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;

public class EmailContact
extends AbstractOptionHandler
implements Comparable<EmailContact>,
ShallowCopySupporter<EmailContact> {
    private static final long serialVersionUID = 8140311860464886389L;
    protected String m_FirstName;
    protected String m_LastName;
    protected String m_Email;
    protected String m_Address;
    protected String m_Phone;
    protected String m_Note;

    public String globalInfo() {
        return "Encapsulates a basic email contact.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("first", "firstName", (Object)"");
        this.m_OptionManager.add("last", "lastName", (Object)"");
        this.m_OptionManager.add("email", "email", (Object)"");
        this.m_OptionManager.add("phone", "phone", (Object)"");
        this.m_OptionManager.add("address", "address", (Object)"");
        this.m_OptionManager.add("note", "note", (Object)"");
    }

    public void setFirstName(String value) {
        if (value == null) {
            value = "";
        }
        this.m_FirstName = value;
        this.reset();
    }

    public String getFirstName() {
        return this.m_FirstName;
    }

    public String firstNameTipText() {
        return "The first name.";
    }

    public void setLastName(String value) {
        if (value == null) {
            value = "";
        }
        this.m_LastName = value;
        this.reset();
    }

    public String getLastName() {
        return this.m_LastName;
    }

    public String lastNameTipText() {
        return "The last name.";
    }

    public void setEmail(String value) {
        if (value == null) {
            value = "";
        }
        this.m_Email = value;
        this.reset();
    }

    public String getEmail() {
        return this.m_Email;
    }

    public String emailTipText() {
        return "The email address (uniquely identifies a contact).";
    }

    public void setPhone(String value) {
        if (value == null) {
            value = "";
        }
        this.m_Phone = value;
        this.reset();
    }

    public String getPhone() {
        return this.m_Phone;
    }

    public String phoneTipText() {
        return "An optional phone.";
    }

    public void setAddress(String value) {
        if (value == null) {
            value = "";
        }
        this.m_Address = value;
        this.reset();
    }

    public String getAddress() {
        return this.m_Address;
    }

    public String addressTipText() {
        return "An optional address.";
    }

    public void setNote(String value) {
        if (value == null) {
            value = "";
        }
        this.m_Note = value;
        this.reset();
    }

    public String getNote() {
        return this.m_Note;
    }

    public String noteTipText() {
        return "An optional note.";
    }

    @Override
    public int compareTo(EmailContact o) {
        if (o == null) {
            return 1;
        }
        int result = this.m_Email.compareTo(o.m_Email);
        if (result == 0) {
            result = this.m_LastName.compareTo(o.m_LastName);
        }
        if (result == 0) {
            result = this.m_FirstName.compareTo(o.m_FirstName);
        }
        if (result == 0) {
            result = this.m_Phone.compareTo(o.m_Phone);
        }
        if (result == 0) {
            result = this.m_Address.compareTo(o.m_Address);
        }
        if (result == 0) {
            result = this.m_Note.compareTo(o.m_Note);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EmailContact) {
            return this.compareTo((EmailContact)obj) == 0;
        }
        return false;
    }

    public EmailContact shallowCopy() {
        return this.shallowCopy(false);
    }

    public EmailContact shallowCopy(boolean expand) {
        return (EmailContact)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public EmailAddress toEmailAddress() {
        String name = this.m_FirstName + " " + this.m_LastName;
        EmailAddress result = (name = name.trim()).length() > 0 ? new EmailAddress(Utils.doubleQuote((String)name) + " <" + this.getEmail() + ">") : new EmailAddress(this.getEmail());
        return result;
    }
}

