/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.logging.LoggingHelper;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.io.File;

@MixedCopyright(copyright="JCraft", license=License.BSD3, url="http://www.jcraft.com/jsch/")
public class JSchUtils {
    private static final adams.core.logging.Logger LOGGER = LoggingHelper.getConsoleLogger(JSchUtils.class);

    public static JSch newJsch(File knownHosts) throws Exception {
        JSch result = new JSch();
        JSch.setLogger((Logger)new Logger(){

            public boolean isEnabled(int level) {
                return true;
            }

            public void log(int level, String message) {
                switch (level) {
                    case 0: {
                        LOGGER.fine(message);
                        break;
                    }
                    case 1: {
                        LOGGER.info(message);
                        break;
                    }
                    case 2: {
                        LOGGER.warning(message);
                        break;
                    }
                    case 3: 
                    case 4: {
                        LOGGER.severe(message);
                    }
                }
            }
        });
        if (knownHosts != null) {
            result.setKnownHosts(knownHosts.getAbsolutePath());
        }
        return result;
    }

    public static Session newSession(JSch jsch, String user, String password, String host, int port) throws Exception {
        Session result = jsch.getSession(user, host, port);
        result.setPassword(password);
        return result;
    }

    public static Session newSession(JSch jsch, String user, File privateKey, String password, String host, int port) throws Exception {
        if (password == null || password.isEmpty()) {
            jsch.addIdentity(privateKey.getAbsolutePath());
        } else {
            jsch.addIdentity(privateKey.getAbsolutePath(), password);
        }
        Session result = jsch.getSession(user, host, port);
        return result;
    }

    public static void configureStrictHostKeyChecking(Session session, boolean strict) {
        session.setConfig("StrictHostKeyChecking", strict ? "yes" : "no");
    }

    public static void configureX11(Session session, String host, int port) {
        session.setX11Host(host);
        session.setX11Port(port);
    }
}

