/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.Properties;
import adams.core.net.hostnameverifier.All;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLHelper {
    public static final String FILENAME = "SSL.props";
    public static final String HOSTNAME_VERIFIER = "HostnameVerifier";
    public static final String TRUST_MANAGER = "TrustManager";
    protected static Properties m_Properties;

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Environment.getInstance().read("ssl");
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public static synchronized boolean writeProperties() {
        return SSLHelper.writeProperties(SSLHelper.getProperties());
    }

    public static synchronized boolean writeProperties(Properties props) {
        boolean result = Environment.getInstance().write("ssl", props);
        m_Properties = null;
        return result;
    }

    public static HostnameVerifier getHostnameVerifier() {
        HostnameVerifier result;
        String cmdline = SSLHelper.getProperties().getProperty(HOSTNAME_VERIFIER, OptionUtils.getCommandLine((Object)new All()));
        try {
            result = (HostnameVerifier)OptionUtils.forAnyCommandLine(HostnameVerifier.class, (String)cmdline);
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate hostname verifier: " + cmdline);
            e.printStackTrace();
            result = new All();
        }
        return result;
    }

    public static X509TrustManager getTrustManager() {
        X509TrustManager result;
        String cmdline = SSLHelper.getProperties().getProperty(TRUST_MANAGER, OptionUtils.getCommandLine((Object)new adams.core.net.trustmanager.All()));
        try {
            result = (X509TrustManager)OptionUtils.forAnyCommandLine(X509TrustManager.class, (String)cmdline);
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate trust manager: " + cmdline);
            e.printStackTrace();
            result = new adams.core.net.trustmanager.All();
        }
        return result;
    }

    public static synchronized boolean initialize() {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{SSLHelper.getTrustManager()}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(SSLHelper.getHostnameVerifier());
            return true;
        }
        catch (Exception e) {
            System.err.println("Failed to initialize SSL context:");
            e.printStackTrace();
            return false;
        }
    }
}

