/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import java.net.URLEncoder;

public class StringArrayToURLParameters
extends AbstractConversion
implements EncodingSupporter {
    private static final long serialVersionUID = 8430779020000469313L;
    protected BaseCharset m_Encoding;

    public String globalInfo() {
        return "Turns a string array into parameters of a URL, e.g., '?k1=v1&k2=v2' (uses " + Utils.classToString(URLEncoder.class) + ").";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset("UTF-8"));
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use for the encoding.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"encoding", (Object)this.m_Encoding);
    }

    public Class accepts() {
        return String[].class;
    }

    public Class generates() {
        return String.class;
    }

    protected Object doConvert() throws Exception {
        StringBuilder result = new StringBuilder();
        String[] input = (String[])this.m_Input;
        for (int i = 0; i < input.length; ++i) {
            if (i == 0) {
                result.append("?");
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(input[i], this.m_Encoding.stringValue()));
        }
        return result.toString();
    }
}

