/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.net.Base64Type;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractStringConversion;
import java.util.Base64;

public class StringToBase64
extends AbstractStringConversion {
    private static final long serialVersionUID = 1383459505178870114L;
    protected Base64Type m_Type;

    public String globalInfo() {
        return "Encodes a string as base64.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)Base64Type.BASIC);
    }

    public void setType(Base64Type value) {
        this.m_Type = value;
        this.reset();
    }

    public Base64Type getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of conversion to use; " + (Object)((Object)Base64Type.AUTO) + " is not allowed.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    protected Object doConvert() throws Exception {
        switch (this.m_Type) {
            case AUTO: {
                throw new IllegalStateException("Not allowed: " + (Object)((Object)this.m_Type));
            }
            case BASIC: {
                return new String(Base64.getEncoder().encode(((String)this.m_Input).getBytes()));
            }
            case URL_FILENAME_SAFE: {
                return new String(Base64.getUrlEncoder().encode(((String)this.m_Input).getBytes()));
            }
            case MIME: {
                return new String(Base64.getMimeEncoder().encode(((String)this.m_Input).getBytes()));
            }
        }
        throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
    }
}

