/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.net.Email;
import adams.core.net.EmailAddress;
import adams.data.io.input.AbstractEmailFileReader;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import jodd.mail.EmailMessage;
import jodd.mail.EmailUtil;
import jodd.mail.ReceivedEmail;

public class EmlEmailFileReader
extends AbstractEmailFileReader {
    private static final long serialVersionUID = -341050738394654936L;

    public String globalInfo() {
        return "Reads emails stored in EML files.";
    }

    @Override
    public String getFormatDescription() {
        return "EML files";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"eml"};
    }

    @Override
    protected Email doRead() {
        Email result = null;
        try {
            ReceivedEmail email = EmailUtil.parseEML((File)this.m_Input.getAbsoluteFile());
            List msgs = email.getAllMessages();
            StringBuilder body = new StringBuilder();
            for (int i = 0; i < msgs.size(); ++i) {
                if (msgs.size() > 1) {
                    body.append("---Message #" + (i + 1) + " " + ((EmailMessage)msgs.get(i)).getMimeType() + " " + ((EmailMessage)msgs.get(i)).getEncoding() + "\n");
                }
                body.append(((EmailMessage)msgs.get(i)).getContent());
                body.append("\n");
            }
            result = new Email(new EmailAddress(email.getFrom()), (EmailAddress[])EmailAddress.toObjectArray((String[])email.getTo(), EmailAddress.class), (EmailAddress[])EmailAddress.toObjectArray((String[])email.getCc(), EmailAddress.class), (EmailAddress[])EmailAddress.toObjectArray((String[])email.getBcc(), EmailAddress.class), email.getSubject(), body.toString(), new File[0]);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read: " + this.m_Input, (Throwable)e);
        }
        return result;
    }
}

